/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.dialog.SelectTypeDialog;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class RefactorAttributeTypeFeature
extends AbstractCustomFeature {
    public RefactorAttributeTypeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo == null || !(bo instanceof JavaPersistentAttribute)) {
            return;
        }
        JavaPersistentAttribute jpa = (JavaPersistentAttribute)bo;
        String typeName = JPAEditorUtil.getAttributeTypeNameWithGenerics(jpa);
        String msg = MessageFormat.format(JPAEditorMessages.SelectTypeDialog_chooseAttributeTypeDialogText, jpa.getName(), JPAEditorUtil.returnSimpleName(((PersistentType)jpa.getParent()).getName()));
        SelectTypeDialog d = new SelectTypeDialog(msg, typeName);
        if (d.open() != 0) {
            return;
        }
        String newTypeName = d.getTypeName();
        String[] attributeTypeTypeNames = JPAEditorUtil.getGenericsElementTypes(newTypeName);
        if (attributeTypeTypeNames != null) {
            newTypeName = newTypeName.substring(0, newTypeName.indexOf(60)).trim();
        }
        this.getFeatureProvider().addAddIgnore((JavaPersistentType)jpa.getParent(), jpa.getName());
        JavaResourceAttribute jra = jpa.getResourceAttribute();
        this.getFeatureProvider().addRemoveIgnore((JavaPersistentType)jpa.getParent(), jra.getName());
        boolean isMethodAnnotated = jra.getKind() == JavaResourceAnnotatedElement.Kind.METHOD;
        List<String> annotations = JpaArtifactFactory.instance().getAnnotationStrings(jpa);
        JpaArtifactFactory.instance().deleteAttribute((JavaPersistentType)jpa.getParent(), jpa.getName(), this.getFeatureProvider());
        JavaPersistentAttribute newAt = JpaArtifactFactory.instance().createANewAttribute((JavaPersistentType)jpa.getParent(), jpa.getName(), newTypeName, attributeTypeTypeNames, jpa.getName(), annotations, false, isMethodAnnotated, this.getFeatureProvider());
        this.getFeatureProvider().replaceAttribute(jpa, newAt);
        IWorkbenchPartSite ws = ((IEditorPart)this.getDiagramEditor()).getSite();
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit((JavaPersistentType)newAt.getParent());
        this.getFeatureProvider().getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
        JpaArtifactFactory.instance().remakeRelations(this.getFeatureProvider(), ((Shape)pe).getContainer(), (JavaPersistentType)newAt.getParent());
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public String getName() {
        return JPAEditorMessages.RefactorAttributeTypeFeature_ContextMenuOperationDescription;
    }
}

