/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.GraphicalRemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class RemoveAttributeFeature
extends DefaultRemoveFeature {
    private boolean skipRemoveRelations = false;
    private boolean skipCreateRelations = false;
    private JavaPersistentType jpt = null;
    private ICustomFeature graphicalRemove;

    public RemoveAttributeFeature(IFeatureProvider fp) {
        this(fp, (ICustomFeature)new GraphicalRemoveAttributeFeature(fp));
    }

    public RemoveAttributeFeature(IFeatureProvider fp, boolean skipRemoveRelations, boolean skipCreateRelations) {
        this(fp);
        this.skipRemoveRelations = skipRemoveRelations;
        this.skipCreateRelations = skipCreateRelations;
    }

    public RemoveAttributeFeature(IFeatureProvider fp, ICustomFeature graphicalRemove) {
        super(fp);
        this.graphicalRemove = graphicalRemove;
    }

    public void setKey(String key) {
    }

    public boolean isAvailable(IContext context) {
        return false;
    }

    public boolean canExecute(IContext context) {
        return false;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void preRemove(IRemoveContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe == null) {
            JPADiagramEditorPlugin.logError("PictogramElement is null\n", new Exception());
            return;
        }
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Object bo = fp.getBusinessObjectForPictogramElement(pe);
        if (bo == null) {
            return;
        }
        if (bo instanceof JavaPersistentAttribute) {
            String iterStr;
            Iterator<String> iter;
            JavaPersistentAttribute jpa = (JavaPersistentAttribute)bo;
            HashSet<String> ignores = ((JPAEditorFeatureProvider)this.getFeatureProvider()).getAddIgnore();
            if (!ignores.isEmpty() && (iter = ignores.iterator()).hasNext() && (iterStr = iter.next()).endsWith(jpa.getName())) {
                ignores.remove(iterStr);
            }
            this.jpt = (JavaPersistentType)jpa.getParent();
            fp.remove(fp.getKeyForBusinessObject(bo));
            if (!this.skipRemoveRelations) {
                IRelation rel = fp.getRelationRelatedToAttribute(jpa);
                this.removeRelation(rel);
            }
        }
        ContainerShape entityShape = ((ContainerShape)pe).getContainer().getContainer();
        try {
            this.graphicalRemoveAttribute((PictogramElement)entityShape);
        }
        catch (Exception e) {
            JPADiagramEditorPlugin.logError(e);
        }
    }

    private void graphicalRemoveAttribute(PictogramElement pe) {
        CustomContext customContext = new CustomContext();
        customContext.setInnerPictogramElement(pe);
        this.graphicalRemove.execute((ICustomContext)customContext);
    }

    private void removeRelation(IRelation rel) {
        if (rel == null) {
            return;
        }
        Connection conn = (Connection)this.getFeatureProvider().getPictogramElementForBusinessObject(rel);
        RemoveContext ctx = new RemoveContext((PictogramElement)conn);
        RemoveRelationFeature ft = new RemoveRelationFeature(this.getFeatureProvider());
        ft.remove((IRemoveContext)ctx);
    }

    public void postRemove(IRemoveContext context) {
        if (this.skipCreateRelations) {
            return;
        }
        if (this.jpt == null) {
            return;
        }
        JpaArtifactFactory.instance().refreshEntityModel(this.getFeatureProvider(), this.jpt);
        Collection<IRelation> rels = JpaArtifactFactory.instance().produceAllRelations(this.jpt, this.getFeatureProvider());
        for (IRelation rel : rels) {
            ContainerShape ownerShape = (ContainerShape)this.getFeatureProvider().getPictogramElementForBusinessObject(rel.getOwner());
            ContainerShape inverseShape = (ContainerShape)this.getFeatureProvider().getPictogramElementForBusinessObject(rel.getInverse());
            AddConnectionContext cntx = new AddConnectionContext(JPAEditorUtil.getAnchor(ownerShape), JPAEditorUtil.getAnchor(inverseShape));
            cntx.setNewObject((Object)rel);
            AddRelationFeature ft = new AddRelationFeature(this.getFeatureProvider());
            ft.add((IAddContext)cntx);
        }
        JpaArtifactFactory.instance().rearrangeIsARelations(this.getFeatureProvider());
    }
}

