/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveConnectionDecoratorFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickAddAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickRemoveAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CollapseAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CollapseCompartmentShapeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CollapseEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToManyBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToManyUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateMappedSuperclassFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToManyUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DeleteJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DeleteRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DirectEditAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DirectEditJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ExpandCompartmentShapeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ExpandEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.JPAMoveConnectionDecoratorFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.LayoutJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.MoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.MoveEntityShapeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ResizeAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ResizeJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.IModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtilImpl;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdaterImpl;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IGraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJpaSolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IPeServiceUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtilImpl;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPASolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.PeServiceUtilImpl;
import org.eclipse.ui.PlatformUI;

public class JPAEditorFeatureProvider
extends DefaultFeatureProvider
implements IJPAEditorFeatureProvider {
    private ClickAddAttributeButtonFeature clickAddAttBtnFeat = null;
    private ClickRemoveAttributeButtonFeature clickRemoveAttBtnFeat = null;
    private IPeServiceUtil peServiceUtil = new PeServiceUtilImpl();
    private IPeService peService = Graphiti.getPeService();
    private IJPAEditorUtil jpaEditorUtil = new JPAEditorUtilImpl();
    private IModelIntegrationUtil moinIntegrationUtil = new ModelIntegrationUtilImpl();
    private IGraphicsUpdater graphicsUpdater = new GraphicsUpdaterImpl();

    public JPAEditorFeatureProvider(IDiagramTypeProvider dtp, IJpaSolver is) {
        super(dtp);
        is.setFeatureProvider(this);
        this.setIndependenceSolver(is);
    }

    public void stopThread() {
        if (this.getIndependenceSolver() != null) {
            ((JPASolver)this.getIndependenceSolver()).stopThread();
        }
    }

    @Override
    public Diagram getDiagram() {
        return this.getDiagramTypeProvider().getDiagram();
    }

    @Override
    public HashSet<IsARelation> getAllExistingIsARelations() {
        EList allCons = this.getDiagram().getConnections();
        HashSet<IsARelation> res = new HashSet<IsARelation>();
        HashSet<Connection> tbd = new HashSet<Connection>();
        for (Connection conn : allCons) {
            if (!IsARelation.isIsAConnection(conn)) continue;
            try {
                res.add(new IsARelation(this, conn));
            }
            catch (NullPointerException nullPointerException) {
                tbd.add(conn);
            }
        }
        Iterator it = tbd.iterator();
        while (it.hasNext()) {
            Graphiti.getPeService().deletePictogramElement((PictogramElement)it.next());
        }
        return res;
    }

    @Override
    public HashSet<IsARelation> getAllRedundantIsARelations() {
        EList allCons = this.getDiagram().getConnections();
        HashSet<IsARelation> res = new HashSet<IsARelation>();
        for (Connection conn : allCons) {
            if (!IsARelation.isIsAConnection(conn)) continue;
            res.add(new IsARelation(this, conn));
        }
        return res;
    }

    @Override
    public void removeAllRedundantIsARelations() {
        EList allCons = this.getDiagram().getConnections();
        LinkedList<Connection> redundantConnections = new LinkedList<Connection>();
        for (Connection conn : allCons) {
            if (!IsARelation.isIsAConnection(conn)) continue;
            IsARelation rel = null;
            try {
                rel = new IsARelation(this, conn);
            }
            catch (NullPointerException nullPointerException) {
                redundantConnections.add(conn);
                continue;
            }
            if (rel.getSuperclass().getName().equals(this.getFirstSuperclassBelongingToTheDiagram(rel.getSubclass()).getName())) continue;
            redundantConnections.add(conn);
        }
        for (Connection conn : redundantConnections) {
            this.peService.deletePictogramElement((PictogramElement)conn);
        }
    }

    @Override
    public boolean existRedundantIsARelations() {
        EList allCons = this.getDiagram().getConnections();
        for (Connection conn : allCons) {
            if (!IsARelation.isIsAConnection(conn)) continue;
            IsARelation rel = null;
            try {
                rel = new IsARelation(this, conn);
            }
            catch (NullPointerException nullPointerException) {
                return true;
            }
            if (rel.getSuperclass().equals(this.getFirstSuperclassBelongingToTheDiagram(rel.getSubclass()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaPersistentType getFirstSuperclassBelongingToTheDiagram(JavaPersistentType subclass) {
        Iterable h = subclass.getInheritanceHierarchy();
        Iterator iter = h.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        HashSet<PersistentType> cycleChecker = new HashSet<PersistentType>();
        cycleChecker.add((PersistentType)iter.next());
        while (iter.hasNext()) {
            PersistentType superclass = (PersistentType)iter.next();
            if (this.hasObjectWithName(this.getKeyForBusinessObject(superclass))) {
                return (JavaPersistentType)superclass;
            }
            if (cycleChecker.add(superclass)) continue;
            return null;
        }
        return null;
    }

    @Override
    public void addJPTForUpdate(String jptName) {
        ((JPASolver)this.getIndependenceSolver()).addJPTForUpdate(jptName);
    }

    @Override
    public void addRemoveIgnore(JavaPersistentType jpt, String atName) {
        ((JPASolver)this.getIndependenceSolver()).addRemoveIgnore(String.valueOf(jpt.getName()) + "." + atName);
    }

    @Override
    public void addAddIgnore(JavaPersistentType jpt, String atName) {
        ((JPASolver)this.getIndependenceSolver()).addAddIgnore(String.valueOf(jpt.getName()) + "." + atName);
    }

    public HashSet<String> getAddIgnore() {
        return ((JPASolver)this.getIndependenceSolver()).getAddIgnore();
    }

    @Override
    public void addAttribForUpdate(PersistenceUnit pu, String entAtMappedBy) {
        ((JPASolver)this.getIndependenceSolver()).addAttribForUpdate(pu, entAtMappedBy);
    }

    @Override
    public boolean existsRelation(JavaPersistentType jpt1, JavaPersistentType jpt2) {
        return ((JPASolver)this.getIndependenceSolver()).existsRelation(jpt1, jpt2);
    }

    public IAddFeature getAddFeature(IAddContext context) {
        Object newObj = context.getNewObject();
        if (newObj instanceof JavaPersistentType) {
            return new AddJPAEntityFeature(this, true);
        }
        if (newObj instanceof AbstractRelation) {
            return new AddRelationFeature(this);
        }
        if (newObj instanceof PersistentAttribute) {
            if (Diagram.class.isInstance(context.getTargetContainer())) {
                return null;
            }
            return new AddAttributeFeature(this);
        }
        if (newObj instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)newObj;
            JavaPersistentType jpt = JPAEditorUtil.getJPType((ICompilationUnit)cu);
            if (jpt != null) {
                return new AddJPAEntityFeature(this, true);
            }
        } else {
            if (newObj instanceof JpaNode) {
                return new AddAllEntitiesFeature(this);
            }
            if (newObj instanceof SourceType) {
                return new AddJPAEntityFeature(this, true);
            }
        }
        return super.getAddFeature(context);
    }

    public ICreateFeature[] getCreateFeatures() {
        return new ICreateFeature[]{new CreateJPAEntityFeature(this), new CreateMappedSuperclassFeature(this)};
    }

    @Override
    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof JavaPersistentType) {
            return new DeleteJPAEntityFeature(this);
        }
        if (bo instanceof AbstractRelation) {
            return new DeleteRelationFeature(this);
        }
        if (bo instanceof JavaPersistentAttribute) {
            return new ClickRemoveAttributeButtonFeature(this);
        }
        return null;
    }

    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        ICustomFeature[] ret = super.getCustomFeatures(context);
        ArrayList<Object> retList = new ArrayList<Object>();
        int i = 0;
        while (i < ret.length) {
            retList.add(ret[i]);
            ++i;
        }
        retList.add((Object)new CollapseAllEntitiesFeature(this));
        retList.add((Object)new CollapseEntityFeature(this));
        retList.add((Object)new ExpandEntityFeature(this));
        retList.add((Object)new CollapseCompartmentShapeFeature(this));
        retList.add((Object)new ExpandCompartmentShapeFeature(this));
        ret = retList.toArray(ret);
        return ret;
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (this.getBusinessObjectForPictogramElement(pe) instanceof JavaPersistentType) {
            return new ResizeJPAEntityFeature(this);
        }
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga == null) {
            return super.getResizeShapeFeature(context);
        }
        EList ch = ga.getGraphicsAlgorithmChildren();
        if (ch != null && ch.size() > 0 && ch.get(0) instanceof Text) {
            return new ResizeAttributeFeature(this);
        }
        return super.getResizeShapeFeature(context);
    }

    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof JavaPersistentType) {
            return new LayoutJPAEntityFeature(this);
        }
        return super.getLayoutFeature(context);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo == null) {
            super.getRemoveFeature(context);
        }
        if (bo instanceof JavaPersistentType) {
            return new RemoveJPAEntityFeature(this, true);
        }
        if (bo instanceof AbstractRelation) {
            return new RemoveRelationFeature(this);
        }
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga == null) {
            return super.getRemoveFeature(context);
        }
        EList ch = ga.getGraphicsAlgorithmChildren();
        if (ch != null && ch.size() > 0 && ch.get(0) instanceof Text) {
            return new RemoveAttributeFeature(this);
        }
        return super.getRemoveFeature(context);
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new CreateOneToOneUniDirRelationFeature(this), new CreateOneToOneBiDirRelationFeature(this), new CreateOneToManyUniDirRelationFeature(this), new CreateManyToOneUniDirRelationFeature(this), new CreateManyToOneBiDirRelationFeature(this), new CreateManyToManyUniDirRelationFeature(this), new CreateManyToManyBiDirRelationFeature(this)};
    }

    public IReason canAdd(IAddContext context) {
        return Reason.createTrueReason();
    }

    @Override
    public ICustomFeature getAddAllEntitiesFeature() {
        return new AddAllEntitiesFeature(this);
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (JavaPersistentType.class.isInstance(bo)) {
            return new MoveEntityShapeFeature(this);
        }
        if (bo == null) {
            return new MoveAttributeFeature(this);
        }
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (ga == null) {
            return super.getMoveShapeFeature(context);
        }
        EList ch = ga.getGraphicsAlgorithmChildren();
        if (ch != null && ch.size() > 0 && ch.get(0) instanceof Text) {
            return new MoveAttributeFeature(this);
        }
        return super.getMoveShapeFeature(context);
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
        if (!(ga instanceof Rectangle)) {
            return super.getDirectEditingFeature(context);
        }
        EList ch = ga.getGraphicsAlgorithmChildren();
        if (ch == null || ch.size() == 0) {
            return super.getDirectEditingFeature(context);
        }
        ga = (GraphicsAlgorithm)ch.get(0);
        if (!(ga instanceof Text)) {
            return super.getDirectEditingFeature(context);
        }
        if (((Text)ga).getFont().isItalic()) {
            return super.getDirectEditingFeature(context);
        }
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo != null && bo instanceof JavaPersistentAttribute) {
            return new DirectEditAttributeFeature(this);
        }
        if (!(pe instanceof Shape)) {
            return super.getDirectEditingFeature(context);
        }
        Shape sh = (Shape)pe;
        ContainerShape csh = sh.getContainer();
        if (csh == null) {
            return super.getDirectEditingFeature(context);
        }
        bo = this.getBusinessObjectForPictogramElement((PictogramElement)csh);
        if (bo instanceof JavaPersistentType) {
            return new DirectEditJPAEntityFeature(this);
        }
        return super.getDirectEditingFeature(context);
    }

    public void addMissingRelations(JavaPersistentType newEntity, ContainerShape newShape) {
        Collection allContainedPictogramElements = Graphiti.getPeService().getAllContainedPictogramElements((PictogramElement)this.getDiagramTypeProvider().getDiagram());
        for (PictogramElement pe : allContainedPictogramElements) {
            JavaPersistentType entity;
            AbstractRelation newRel;
            if (pe == newShape || !(pe instanceof ContainerShape) || (newRel = this.produceNecessaryRelation(newEntity, entity = (JavaPersistentType)this.getBusinessObjectForPictogramElement(pe))) == null) continue;
            JavaPersistentType owner = newRel.getOwner();
            JavaPersistentType inverse = newRel.getInverse();
            ContainerShape ownerShape = (ContainerShape)this.getPictogramElementForBusinessObject(owner);
            ContainerShape inverseShape = (ContainerShape)this.getPictogramElementForBusinessObject(inverse);
            AddRelationFeature f = new AddRelationFeature(this);
            AddConnectionContext ctx = new AddConnectionContext(JPAEditorUtil.getAnchor(ownerShape), JPAEditorUtil.getAnchor(inverseShape));
            f.add((IAddContext)ctx);
        }
    }

    @Override
    public void renewAttributeJoiningStrategyPropertyListener(JavaPersistentAttribute jpa) {
        ((JPASolver)this.getIndependenceSolver()).renewAttributeJoiningStrategyPropertyListener(jpa);
    }

    private AbstractRelation produceNecessaryRelation(JavaPersistentType ent1, JavaPersistentType ent2) {
        return null;
    }

    public String produceKeyForRel(JavaPersistentType jpt, String attributeName) {
        return ((JPASolver)this.getIndependenceSolver()).produceKeyForRel(jpt, attributeName);
    }

    public ClickAddAttributeButtonFeature getClickAddAttributeButtonFeature() {
        if (this.clickAddAttBtnFeat == null) {
            this.clickAddAttBtnFeat = new ClickAddAttributeButtonFeature(this);
        }
        return this.clickAddAttBtnFeat;
    }

    public ClickRemoveAttributeButtonFeature getClickRemoveAttributeButtonFeature() {
        if (this.clickRemoveAttBtnFeat == null) {
            this.clickRemoveAttBtnFeat = new ClickRemoveAttributeButtonFeature(this);
        }
        return this.clickRemoveAttBtnFeat;
    }

    public IMoveConnectionDecoratorFeature getMoveConnectionDecoratorFeature(IMoveConnectionDecoratorContext context) {
        return new JPAMoveConnectionDecoratorFeature(this);
    }

    @Override
    public Object getBusinessObjectForKey(String key) {
        return this.getIndependenceSolver().getBusinessObjectForKey(key);
    }

    @Override
    public String getKeyForBusinessObject(Object bo) {
        return this.getIndependenceSolver().getKeyForBusinessObject(bo);
    }

    @Override
    public void putKeyToBusinessObject(String key, Object bo) {
        ((JPASolver)this.getIndependenceSolver()).addKeyBusinessObject(key, bo);
    }

    @Override
    public Object remove(String key) {
        return this.remove(key, false);
    }

    @Override
    public Object remove(String key, boolean save) {
        Object res = this.getBusinessObjectForKey(key);
        if (res instanceof JavaPersistentType) {
            final JavaPersistentType jpt = (JavaPersistentType)res;
            if (save) {
                JpaArtifactFactory.instance().forceSaveEntityClass(jpt, this);
            }
            if (!(jpt.getMapping() instanceof JavaEntity)) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        JPAEditorFeatureProvider.this.removeFromDiagramIfNotEntity(jpt);
                    }
                });
            }
        }
        return ((JPASolver)this.getIndependenceSolver()).remove(key);
    }

    @Override
    public Collection<JavaPersistentType> getPersistentTypes() {
        return ((JPASolver)this.getIndependenceSolver()).getPersistentTypes();
    }

    protected void removeAllConnections(Shape shape) {
        for (Anchor anchor : shape.getAnchors()) {
            for (Connection connection : Graphiti.getPeService().getAllConnections(anchor)) {
                if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)connection)) continue;
                Object ob = this.getBusinessObjectForPictogramElement((PictogramElement)connection);
                if (ob instanceof AbstractRelation) {
                    String key = this.getKeyForBusinessObject(ob);
                    ((JPASolver)this.getIndependenceSolver()).remove(key);
                }
                Graphiti.getPeService().deletePictogramElement((PictogramElement)connection);
            }
        }
    }

    private void removeFromDiagramIfNotEntity(JavaPersistentType jpt) {
        final PictogramElement cs = this.getPictogramElementForBusinessObject(jpt);
        if (cs != null) {
            final Shape shape = (Shape)cs;
            TransactionalEditingDomain ted = ModelIntegrationUtil.getTransactionalEditingDomain(this.getDiagramTypeProvider().getDiagram());
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    JPAEditorFeatureProvider.this.removeAllConnections(shape);
                    Graphiti.getPeService().deletePictogramElement(cs);
                }
            });
        }
    }

    @Override
    public boolean hasObjectWithName(String name) {
        return ((JPASolver)this.getIndependenceSolver()).containsKey(name);
    }

    @Override
    public void replaceAttribute(final JavaPersistentAttribute oldAt, final JavaPersistentAttribute newAt) {
        final PictogramElement pe = this.getPictogramElementForBusinessObject(oldAt);
        if (pe == null) {
            throw new RuntimeException();
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pe);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                JPASolver solver = (JPASolver)JPAEditorFeatureProvider.this.getIndependenceSolver();
                solver.remove(solver.getKeyForBusinessObject(oldAt));
                solver.addKeyBusinessObject(solver.getKeyForBusinessObject(newAt), newAt);
                if (newAt == null) {
                    JPADiagramEditorPlugin.logError("New attribute is null\n", new Exception());
                    return;
                }
                JPAEditorFeatureProvider.this.link(pe, newAt);
                GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
                if (ga == null) {
                    return;
                }
                EList ch = ga.getGraphicsAlgorithmChildren();
                ((Text)ch.get(0)).setValue(newAt.getName());
            }
        });
    }

    @Override
    public boolean doesRelationExist(JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, IRelation.RelType relType, IRelation.RelDir relDir) {
        String id = AbstractRelation.generateId(owner, inverse, ownerAttributeName, relType, relDir);
        return this.getBusinessObjectForKey(id) != null;
    }

    public boolean isRelationRelatedToAttribute(JavaPersistentAttribute jpa) {
        return ((JPASolver)this.getIndependenceSolver()).isRelationRelatedToAttribute(jpa);
    }

    @Override
    public IRelation getRelationRelatedToAttribute(JavaPersistentAttribute jpa) {
        return ((JPASolver)this.getIndependenceSolver()).getRelationRelatedToAttribute(jpa);
    }

    @Override
    public ICompilationUnit getCompilationUnit(JavaPersistentType jpt) {
        return ((JPASolver)this.getIndependenceSolver()).getCompilationUnit(jpt);
    }

    @Override
    public void restoreEntity(JavaPersistentType jpt) {
        ((JPASolver)this.getIndependenceSolver()).restoreEntity(jpt);
    }

    @Override
    public int getAttribsNum(Shape sh) {
        String s = Graphiti.getPeService().getPropertyValue((PropertyContainer)sh, JPAEditorConstants.PROP_ATTRIBS_NUM);
        int res = 0;
        if (s == null) {
            this.setAttribsNum(0, sh);
        } else {
            res = Integer.parseInt(s);
        }
        return res;
    }

    @Override
    public int increaseAttribsNum(Shape sh) {
        int attribsNum = this.getAttribsNum(sh);
        this.setAttribsNum(++attribsNum, sh);
        return attribsNum;
    }

    @Override
    public int decreaseAttribsNum(Shape sh) {
        int attribsNum = this.getAttribsNum(sh);
        this.setAttribsNum(--attribsNum, sh);
        return attribsNum;
    }

    public void setAttribsNum(int newAttribsNum, Shape sh) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)sh, JPAEditorConstants.PROP_ATTRIBS_NUM, "" + newAttribsNum);
    }

    public void dispose() {
        this.stopThread();
        ((JPASolver)this.getIndependenceSolver()).dispose();
        this.setIndependenceSolver(null);
    }

    @Override
    public IPeService getPeService() {
        return this.peService;
    }

    @Override
    public IPeServiceUtil getPeServiceUtil() {
        return this.peServiceUtil;
    }

    @Override
    public IJPAEditorUtil getJPAEditorUtil() {
        return this.jpaEditorUtil;
    }

    @Override
    public IModelIntegrationUtil getMoinIntegrationUtil() {
        return this.moinIntegrationUtil;
    }

    @Override
    public IGraphicsUpdater getGraphicsUpdater() {
        return this.graphicsUpdater;
    }

    @Override
    public TransactionalEditingDomain getTransactionalEditingDomain() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        return TransactionUtil.getEditingDomain((EObject)diagram);
    }

    public PictogramElement getPictogramElementForBusinessObject(Object businessObject) {
        PictogramElement pe = super.getPictogramElementForBusinessObject(businessObject);
        return pe;
    }

    @Override
    public Properties loadProperties(IProject project) {
        return JPADiagramPropertyPage.loadProperties(project);
    }
}

