/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.provider;

import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.swt.graphics.Point;

public class JPAEditorImageCreator
implements IJPAEditorImageCreator {
    @Override
    public Polyline createConnectionLine(Diagram d, Connection connection) {
        Polyline polyline = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setForeground(Graphiti.getGaService().manageColor(d, JPAEditorConstants.CONNECTION_LINE_COLOR));
        polyline.setLineWidth(Integer.valueOf(2));
        return polyline;
    }

    @Override
    public Polyline createIsAConnectionLine(Diagram d, Connection connection) {
        Polyline polyline = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setForeground(Graphiti.getGaService().manageColor(d, JPAEditorConstants.IS_A_CONNECTION_LINE_COLOR));
        polyline.setLineWidth(Integer.valueOf(2));
        polyline.setLineStyle(LineStyle.DASH);
        return polyline;
    }

    @Override
    public ConnectionDecorator createCardinalityConnectionDecorator(Diagram d, Connection c, String text, double location) {
        ConnectionDecorator textDecorator = Graphiti.getPeService().createConnectionDecorator(c, true, location, true);
        Text txt = Graphiti.getGaService().createDefaultText(d, (GraphicsAlgorithmContainer)textDecorator);
        txt.setLineWidth(Integer.valueOf(2));
        txt.setValue(text);
        Graphiti.getGaService().manageColor(c.getParent(), IColorConstant.BLACK);
        Point pt = JPAEditorUtil.recalcTextDecoratorPosition((FreeFormConnection)c, textDecorator);
        Graphiti.getGaService().setLocation((GraphicsAlgorithm)txt, pt.x, pt.y, false);
        return textDecorator;
    }

    @Override
    public ConnectionDecorator createArrowConnectionDecorator(Connection connection, double location, boolean isA) {
        ConnectionDecorator cd = Graphiti.getPeService().createConnectionDecorator(connection, false, location, true);
        int[] nArray = new int[8];
        nArray[0] = 11;
        nArray[1] = 3;
        nArray[4] = 11;
        nArray[5] = -3;
        nArray[6] = 11;
        nArray[7] = 3;
        Polyline arrow = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)cd, nArray);
        arrow.setForeground(Graphiti.getGaService().manageColor(connection.getParent(), isA ? JPAEditorConstants.IS_A_CONNECTION_LINE_COLOR : JPAEditorConstants.CONNECTION_LINE_COLOR));
        arrow.setLineWidth(Integer.valueOf(2));
        return cd;
    }

    @Override
    public ConnectionDecorator createManyEndWithArrowDecorator(Connection connection, double location) {
        ConnectionDecorator cd = Graphiti.getPeService().createConnectionDecorator(connection, false, location, true);
        Polyline arrow = null;
        int[] nArray = new int[14];
        nArray[0] = -2;
        nArray[1] = 7;
        nArray[2] = 6;
        nArray[4] = -2;
        nArray[5] = -7;
        nArray[6] = 6;
        nArray[8] = 20;
        nArray[9] = 3;
        nArray[10] = 20;
        nArray[11] = -3;
        nArray[12] = 7;
        arrow = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)cd, nArray);
        arrow.setForeground(Graphiti.getGaService().manageColor(connection.getParent(), JPAEditorConstants.CONNECTION_LINE_COLOR));
        arrow.setLineWidth(Integer.valueOf(2));
        return cd;
    }

    @Override
    public ConnectionDecorator createManyEndDecorator(Connection connection, double location) {
        ConnectionDecorator cd = Graphiti.getPeService().createConnectionDecorator(connection, false, location, true);
        Polyline arrow = null;
        int[] nArray = new int[6];
        nArray[1] = 7;
        nArray[2] = 8;
        nArray[5] = -7;
        arrow = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)cd, nArray);
        arrow.setForeground(Graphiti.getGaService().manageColor(connection.getParent(), JPAEditorConstants.CONNECTION_LINE_COLOR));
        arrow.setLineWidth(Integer.valueOf(2));
        return cd;
    }

    @Override
    public ConnectionDecorator createManyStartDecorator(Connection connection, double location) {
        ConnectionDecorator cd = Graphiti.getPeService().createConnectionDecorator(connection, false, location, true);
        Polyline arrow = null;
        int[] nArray = new int[6];
        nArray[1] = 7;
        nArray[2] = -8;
        nArray[5] = -7;
        arrow = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)cd, nArray);
        arrow.setForeground(Graphiti.getGaService().manageColor(connection.getParent(), JPAEditorConstants.CONNECTION_LINE_COLOR));
        arrow.setLineWidth(Integer.valueOf(2));
        return cd;
    }

    @Override
    public ConnectionDecorator createIconConnectionDecorator(Connection connection, String iconId, double location) {
        ConnectionDecorator iconDecorator = Graphiti.getPeService().createConnectionDecorator(connection, true, location, true);
        Image icon = Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)connection, iconId);
        Graphiti.getGaService().setLocation((GraphicsAlgorithm)icon, 5, -20);
        return iconDecorator;
    }

    @Override
    public ConnectionDecorator createIsATextConnectionDecorator(Diagram d, Connection c) {
        ConnectionDecorator textDecorator = Graphiti.getPeService().createConnectionDecorator(c, true, 0.5, true);
        Text txt = Graphiti.getGaService().createDefaultText(d, (GraphicsAlgorithmContainer)textDecorator);
        txt.setLineWidth(Integer.valueOf(2));
        txt.setValue("is-a");
        Graphiti.getGaService().manageColor(c.getParent(), IColorConstant.BLACK);
        Graphiti.getGaService().setLocation((GraphicsAlgorithm)txt, 5, 5, false);
        return textDecorator;
    }
}

