/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.oxm.XMLConstants;

public class Helper {
    protected ClassLoader loader;
    protected JavaModel jModel;
    private HashMap xmlToJavaTypeMap;
    public static final String APBYTE = "byte[]";
    public static final String BIGDECIMAL = "java.math.BigDecimal";
    public static final String BIGINTEGER = "java.math.BigInteger";
    public static final String PBOOLEAN = "boolean";
    public static final String PBYTE = "byte";
    public static final String CALENDAR = "java.util.Calendar";
    public static final String CHARACTER = "java.lang.Character";
    public static final String CHAR = "char";
    public static final String OBJECT = "java.lang.Object";
    public static final String CLASS = "java.lang.Class";
    public static final String PDOUBLE = "double";
    public static final String PFLOAT = "float";
    public static final String PINT = "int";
    public static final String PLONG = "long";
    public static final String PSHORT = "short";
    public static final String QNAME_CLASS = "javax.xml.namespace.QName";
    public static final String STRING = "java.lang.String";
    public static final String ABYTE = "java.lang.Byte[]";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String GREGORIAN_CALENDAR = "java.util.GregorianCalendar";
    public static final String DOUBLE = "java.lang.Double";
    public static final String FLOAT = "java.lang.Float";
    public static final String INTEGER = "java.lang.Integer";
    public static final String UUID = "java.util.UUID";
    public static final String LONG = "java.lang.Long";
    public static final String SHORT = "java.lang.Short";
    public static final String UTIL_DATE = "java.util.Date";
    public static final String SQL_DATE = "java.sql.Date";
    public static final String SQL_TIME = "java.sql.Time";
    public static final String SQL_TIMESTAMP = "java.sql.Timestamp";
    public static final String DURATION = "javax.xml.datatype.Duration";
    public static final String XMLGREGORIANCALENDAR = "javax.xml.datatype.XMLGregorianCalendar";
    public static final String URI = "java.net.URI";
    public static final String URL = "java.net.URL";
    protected static final String JAVA_PKG = "java.";
    protected static final String JAVAX_PKG = "javax.";
    protected static final String JAVAX_WS_PKG = "javax.xml.ws.";

    public Helper(JavaModel model) {
        this.buildXMLToJavaTypeMap();
        this.setJavaModel(model);
        this.setClassLoader(model.getClassLoader());
    }

    private HashMap buildXMLToJavaTypeMap() {
        HashMap<String, QName> javaTypes = new HashMap<String, QName>();
        javaTypes.put(APBYTE, XMLConstants.BASE_64_BINARY_QNAME);
        javaTypes.put(BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        javaTypes.put(BIGINTEGER, XMLConstants.INTEGER_QNAME);
        javaTypes.put(PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(PBYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(PDOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(PFLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(PINT, XMLConstants.INT_QNAME);
        javaTypes.put(PLONG, XMLConstants.LONG_QNAME);
        javaTypes.put(PSHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(QNAME_CLASS, XMLConstants.QNAME_QNAME);
        javaTypes.put(STRING, XMLConstants.STRING_QNAME);
        javaTypes.put(CHAR, XMLConstants.STRING_QNAME);
        javaTypes.put(CHARACTER, XMLConstants.STRING_QNAME);
        javaTypes.put(ABYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        javaTypes.put(BYTE, XMLConstants.BYTE_QNAME);
        javaTypes.put(CLASS, XMLConstants.STRING_QNAME);
        javaTypes.put(GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(DOUBLE, XMLConstants.DOUBLE_QNAME);
        javaTypes.put(FLOAT, XMLConstants.FLOAT_QNAME);
        javaTypes.put(INTEGER, XMLConstants.INT_QNAME);
        javaTypes.put(LONG, XMLConstants.LONG_QNAME);
        javaTypes.put(OBJECT, XMLConstants.ANY_TYPE_QNAME);
        javaTypes.put(SHORT, XMLConstants.SHORT_QNAME);
        javaTypes.put(UTIL_DATE, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(SQL_DATE, XMLConstants.DATE_QNAME);
        javaTypes.put(SQL_TIME, XMLConstants.TIME_QNAME);
        javaTypes.put(SQL_TIMESTAMP, XMLConstants.DATE_TIME_QNAME);
        javaTypes.put(DURATION, XMLConstants.DURATION_QNAME);
        javaTypes.put(UUID, XMLConstants.STRING_QNAME);
        javaTypes.put(URI, XMLConstants.STRING_QNAME);
        javaTypes.put(URL, XMLConstants.ANY_URI_QNAME);
        return javaTypes;
    }

    public JavaClass getGenericReturnType(JavaMethod meth) {
        JavaClass result = meth.getReturnType();
        JavaClass jClass = null;
        if (result == null) {
            return null;
        }
        if (result.hasActualTypeArguments()) {
            ArrayList typeArgs = (ArrayList)result.getActualTypeArguments();
            jClass = (JavaClass)typeArgs.get(0);
        }
        return jClass;
    }

    public JavaClass getJavaClass(Class javaClass) {
        return this.jModel.getClass(javaClass);
    }

    public JavaClass getJavaClass(String javaClassName) {
        return this.jModel.getClass(javaClassName);
    }

    public HashMap getXMLToJavaTypeMap() {
        if (this.xmlToJavaTypeMap == null) {
            this.xmlToJavaTypeMap = this.buildXMLToJavaTypeMap();
        }
        return this.xmlToJavaTypeMap;
    }

    public Annotation getAnnotation(JavaHasAnnotations element, Class annotationClass) {
        JavaAnnotation janno = element.getAnnotation(this.jModel.getClass(annotationClass));
        if (janno == null) {
            return null;
        }
        return this.jModel.getAnnotation(janno, annotationClass);
    }

    public JavaClass getType(JavaField field) {
        JavaClass type = field.getResolvedType();
        try {
            return this.jModel.getClass(type.getRawName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAnnotationPresent(JavaHasAnnotations element, Class annotationClass) {
        if (element == null || annotationClass == null) {
            return false;
        }
        return element.getAnnotation(this.jModel.getClass(annotationClass)) != null;
    }

    public boolean isBuiltInJavaType(JavaClass jClass) {
        String rawName = jClass.getRawName();
        if (rawName == null) {
            return true;
        }
        return this.getXMLToJavaTypeMap().containsKey(rawName) || rawName.startsWith(JAVA_PKG) || rawName.startsWith(JAVAX_PKG) && !rawName.startsWith(JAVAX_WS_PKG);
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setJavaModel(JavaModel model) {
        this.jModel = model;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Class getClassForJavaClass(JavaClass javaClass) {
        String javaClassName = javaClass.getRawName();
        if (javaClass.isPrimitive() || javaClass.isArray() && javaClass.getComponentType().isPrimitive()) {
            if (ClassConstants.APBYTE.getCanonicalName().equals(javaClassName)) {
                return Byte[].class;
            }
            if (ClassConstants.PBYTE.getCanonicalName().equals(javaClassName)) {
                return Byte.class;
            }
            if (ClassConstants.PBOOLEAN.getCanonicalName().equals(javaClassName)) {
                return Boolean.class;
            }
            if (ClassConstants.PSHORT.getCanonicalName().equals(javaClassName)) {
                return Short.class;
            }
            if (ClassConstants.PFLOAT.getCanonicalName().equals(javaClassName)) {
                return Float.class;
            }
            if (ClassConstants.PCHAR.getCanonicalName().equals(javaClassName)) {
                return Character.class;
            }
            if (ClassConstants.PDOUBLE.getCanonicalName().equals(javaClassName)) {
                return Double.class;
            }
            if (ClassConstants.PINT.getCanonicalName().equals(javaClassName)) {
                return Integer.class;
            }
            if (ClassConstants.PLONG.getCanonicalName().equals(javaClassName)) {
                return Long.class;
            }
            return null;
        }
        return org.eclipse.persistence.internal.helper.Helper.getClassFromClasseName((String)javaClass.getQualifiedName(), (ClassLoader)this.loader);
    }

    public boolean classExistsInArray(JavaClass theClass, ArrayList<JavaClass> existingClasses) {
        for (JavaClass jClass : existingClasses) {
            if (!this.areClassesEqual(jClass, theClass)) continue;
            return true;
        }
        return false;
    }

    private boolean areClassesEqual(JavaClass classA, JavaClass classB) {
        if (classA == classB) {
            return true;
        }
        if (!classA.getQualifiedName().equals(classB.getQualifiedName())) {
            return false;
        }
        if (classA.getActualTypeArguments() != null) {
            if (classB.getActualTypeArguments() == null) {
                return false;
            }
            if (classA.getActualTypeArguments().size() != classB.getActualTypeArguments().size()) {
                return false;
            }
            int i = 0;
            while (i < classA.getActualTypeArguments().size()) {
                JavaClass nestedClassB;
                JavaClass nestedClassA = (JavaClass)classA.getActualTypeArguments().toArray()[i];
                if (!this.areClassesEqual(nestedClassA, nestedClassB = (JavaClass)classB.getActualTypeArguments().toArray()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return classB.getActualTypeArguments() == null;
    }

    public static String getQualifiedJavaTypeName(String javaTypeName, String packageName) {
        if (packageName != null && packageName.length() > 0 && !packageName.equals("##default") && !javaTypeName.contains(".")) {
            return String.valueOf(packageName) + "." + javaTypeName;
        }
        return javaTypeName;
    }
}

