/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.SimpleFilter;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIteratorTests
extends TestCase {
    private static final String PREFIX = "prefix";

    public FilteringIteratorTests(String name) {
        super(name);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            String string = stream.next();
            if (!string.equals("prefix3")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        FilteringIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildAcceptIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        FilteringIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testAcceptHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testAcceptNext() {
        Iterator<String> stream = this.buildAcceptIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    public void testInnerHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testInnerNext() {
        Iterator<String> stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    public void testRejectHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildRejectIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)2, (int)i);
    }

    public void testRejectNext() {
        Iterator<String> stream = this.buildRejectIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertFalse((String)"bogus reject", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    public void testBothHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildBothIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testLoadNext() {
        Iterator<String> stream = this.buildInnerIterator2();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    public void testFilterHasNext() {
        int i = 0;
        Iterator<String> stream = this.buildFilterIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        FilteringIteratorTests.assertEquals((int)6, (int)i);
    }

    public void testFilterNext() {
        Iterator<String> stream = this.buildFilterIterator();
        while (stream.hasNext()) {
            FilteringIteratorTests.assertTrue((String)"bogus accept", (boolean)stream.next().startsWith(PREFIX));
        }
    }

    private Iterator<String> buildFilteredIterator(Iterator<String> nestedIterator, Filter<String> filter) {
        return new FilteringIterator(nestedIterator, filter);
    }

    private Iterator<String> buildInnerFilteredIterator(Iterator<String> nestedIterator) {
        return new FilteringIterator<String>(nestedIterator){

            protected boolean accept(String s) {
                return s.startsWith(FilteringIteratorTests.PREFIX);
            }
        };
    }

    String getPrefix() {
        return PREFIX;
    }

    private Iterator<String> buildInnerFilteredIterator2(Iterator<String> nestedIterator) {
        return new FilteringIterator<String>(nestedIterator){

            protected boolean accept(String s) {
                return s.startsWith(FilteringIteratorTests.this.getPrefix());
            }
        };
    }

    private Iterator<String> buildNestedIterator() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("prefix1");
        c.add("prefix2");
        c.add("prefix3");
        c.add("4");
        c.add("prefix5");
        c.add("prefix6");
        c.add("prefix7");
        c.add("8");
        return c.iterator();
    }

    private Iterator<String> buildAcceptIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildAcceptFilter(PREFIX));
    }

    private Iterator<String> buildInnerIterator() {
        return this.buildInnerFilteredIterator(this.buildNestedIterator());
    }

    private Iterator<String> buildInnerIterator2() {
        return this.buildInnerFilteredIterator2(this.buildNestedIterator());
    }

    private Iterator<String> buildFilterIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildFilterFilter(PREFIX));
    }

    private Filter<String> buildAcceptFilter(String prefix) {
        return new SimpleFilter<String, String>(prefix){
            private static final long serialVersionUID = 1L;

            public boolean accept(String s) {
                return s.startsWith((String)this.criterion);
            }
        };
    }

    private Iterator<String> buildRejectIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildRejectFilter(PREFIX));
    }

    private Filter<String> buildRejectFilter(String prefix) {
        return new SimpleFilter<String, String>(prefix){
            private static final long serialVersionUID = 1L;

            public boolean reject(String s) {
                return s.startsWith((String)this.criterion);
            }
        };
    }

    private Filter<String> buildFilterFilter(final String prefix) {
        return new Filter<String>(){

            public boolean accept(String s) {
                return s.startsWith(prefix);
            }
        };
    }

    private Iterator<String> buildBothIterator() {
        return this.buildFilteredIterator(this.buildNestedIterator(), this.buildBothFilter(PREFIX));
    }

    private Filter<String> buildBothFilter(String prefix) {
        return new SimpleFilter<String, String>(prefix){
            private static final long serialVersionUID = 1L;

            public boolean reject(String s) {
                return s.startsWith((String)this.criterion);
            }

            public boolean accept(String s) {
                return s.startsWith((String)this.criterion);
            }
        };
    }

    public void testInvalidFilteringIterator() {
        boolean exCaught = false;
        try {
            FilteringIterator iterator = new FilteringIterator(this.buildNestedIterator());
            String s = (String)iterator.next();
            FilteringIteratorTests.fail((String)("invalid string: " + s));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        FilteringIteratorTests.assertTrue((String)"NoSuchElementException not thrown", (boolean)exCaught);
    }
}

