/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.common.utility.tests.internal.iterators.CompositeIteratorTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyCompositeListIteratorTests
extends CompositeIteratorTests {
    public ReadOnlyCompositeListIteratorTests(String name) {
        super(name);
    }

    @Override
    void verifyHasAnother(Iterator<String> stream) {
        super.verifyHasAnother(stream);
        ListIterator stream2 = (ListIterator)stream;
        int i = 0;
        while (stream2.hasPrevious()) {
            stream2.previous();
            ++i;
        }
        ReadOnlyCompositeListIteratorTests.assertEquals((int)8, (int)i);
    }

    @Override
    void verifyAnother(Iterator<String> stream) {
        super.verifyAnother(stream);
        int i = 8;
        ListIterator stream2 = (ListIterator)stream;
        while (stream2.hasPrevious()) {
            ReadOnlyCompositeListIteratorTests.assertEquals((String)"bogus element", (String)String.valueOf(i--), (String)((String)stream2.previous()).substring(0, 1));
        }
    }

    public void testNextIndexPreviousIndex() {
        int i = 0;
        ListIterator stream = (ListIterator)this.buildCompositeIterator();
        ReadOnlyCompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
        ReadOnlyCompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        while (stream.hasNext()) {
            stream.next();
            ReadOnlyCompositeListIteratorTests.assertEquals((int)(++i), (int)stream.nextIndex());
            ReadOnlyCompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        }
        ReadOnlyCompositeListIteratorTests.assertEquals((String)"index is corrupt", (int)8, (int)i);
        ReadOnlyCompositeListIteratorTests.assertEquals((int)i, (int)stream.nextIndex());
        ReadOnlyCompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        while (stream.hasPrevious()) {
            stream.previous();
            ReadOnlyCompositeListIteratorTests.assertEquals((int)(--i), (int)stream.nextIndex());
            ReadOnlyCompositeListIteratorTests.assertEquals((int)(i - 1), (int)stream.previousIndex());
        }
        ReadOnlyCompositeListIteratorTests.assertEquals((String)"index is corrupt", (int)0, (int)i);
    }

    public void testPreviousIndex() {
    }

    @Override
    public void testRemove() {
    }

    @Override
    public void testIllegalStateException() {
    }

    @Override
    public void testEmptyIllegalStateException1() {
    }

    @Override
    public void testEmptyIllegalStateException2() {
    }

    @Override
    void verifyNoSuchElementException(Iterator<String> stream) {
        super.verifyNoSuchElementException(stream);
        ListIterator stream2 = (ListIterator)stream;
        boolean exCaught = false;
        String string = null;
        while (stream2.hasPrevious()) {
            string = (String)stream2.previous();
        }
        try {
            string = (String)stream2.previous();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReadOnlyCompositeListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    @Override
    void verifyUnsupportedOperationException(Iterator<String> stream) {
        super.verifyUnsupportedOperationException(stream);
        boolean exCaught = false;
        ListIterator stream2 = (ListIterator)stream;
        while (stream2.hasPrevious()) {
            Object string = stream2.previous();
            if (!string.equals("333")) continue;
            try {
                stream2.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyCompositeListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    @Override
    void verifyIllegalStateException(Iterator<String> stream) {
        super.verifyIllegalStateException(stream);
        ListIterator stream2 = (ListIterator)stream;
        boolean exCaught = false;
        try {
            stream2.set("junk");
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        ReadOnlyCompositeListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    @Override
    void verifyEmptyHasAnother(Iterator<String> stream) {
        super.verifyEmptyHasAnother(stream);
        ListIterator stream2 = (ListIterator)stream;
        int i = 0;
        while (stream2.hasPrevious()) {
            stream2.previous();
            ++i;
        }
        ReadOnlyCompositeListIteratorTests.assertEquals((int)0, (int)i);
    }

    @Override
    Iterator<String> buildCompositeIterator(Iterator iterators) {
        return new ReadOnlyCompositeListIterator((ListIterator)iterators);
    }

    @Override
    Iterator<String> buildCompositeIterator2() {
        return new ReadOnlyCompositeListIterator(new ListIterator[]{this.buildIterator1(), this.buildIterator2(), this.buildIterator3()});
    }

    @Override
    Iterator<String> buildCompositeIterator3() {
        return new ReadOnlyCompositeListIterator(new ListIterator[]{this.buildIterator1(), this.buildIterator2(), this.buildIterator3()});
    }

    Iterator<String> buildCompositeIterator(String string, ListIterator<String> iterator) {
        return this.buildCompositeListIterator(string, iterator);
    }

    ListIterator<String> buildCompositeListIterator(String string, ListIterator<String> iterator) {
        return new ReadOnlyCompositeListIterator((Object)string, iterator);
    }

    public void testVariedNestedIterators() {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        integerList.add(new Integer(42));
        integerList.add(new Integer(42));
        integerList.add(new Integer(111));
        integerList.add(new Integer(77));
        ArrayList<Float> floatList = new ArrayList<Float>();
        floatList.add(new Float(42.42f));
        floatList.add(new Float(22.22f));
        floatList.add(new Float(111.111f));
        floatList.add(new Float(77.77f));
        ArrayList<ArrayList<Number>> list = new ArrayList<ArrayList<Number>>();
        list.add(integerList);
        list.add(floatList);
        ReadOnlyCompositeListIterator li = new ReadOnlyCompositeListIterator(list);
        while (li.hasNext()) {
            ReadOnlyCompositeListIteratorTests.assertTrue((((Number)li.next()).intValue() > 0 ? 1 : 0) != 0);
        }
    }
}

