/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.swing.Displayable;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPropertyListValueModelAdapterTests
extends TestCase {
    private Junk foo;
    private Junk bar;
    private Junk baz;
    private Junk joo;
    private Junk jar;
    private Junk jaz;
    private Junk tom;
    private Junk dick;
    private Junk harry;

    public ItemPropertyListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.foo = new Junk("this.foo");
        this.bar = new Junk("this.bar");
        this.baz = new Junk("this.baz");
        this.joo = new Junk("this.joo");
        this.jar = new Junk("this.jar");
        this.jaz = new Junk("this.jaz");
        this.tom = new Junk("this.tom");
        this.dick = new Junk("this.dick");
        this.harry = new Junk("this.harry");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testCollectionSynchronization() {
        SimpleCollectionValueModel<Junk> collectionHolder = this.buildCollectionHolder();
        ItemPropertyListValueModelAdapter listValueModel = new ItemPropertyListValueModelAdapter(collectionHolder, new String[]{"displayString", "icon"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.add((Object)this.tom);
        collectionHolder.add((Object)this.dick);
        collectionHolder.add((Object)this.harry);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.remove((Object)this.foo);
        collectionHolder.remove((Object)this.jar);
        collectionHolder.remove((Object)this.harry);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        collectionHolder.setValues(this.buildCollection());
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    public void testListSynchronization() {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemPropertyListValueModelAdapter listValueModel = new ItemPropertyListValueModelAdapter(listHolder, new String[]{"displayString", "icon"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.add(6, (Object)this.tom);
        listHolder.add(7, (Object)this.dick);
        listHolder.add(8, (Object)this.harry);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.remove(8);
        listHolder.remove(0);
        listHolder.remove(4);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
        listHolder.setListValues(this.buildList());
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compare((ListValueModel<Junk>)listValueModel, synchList);
    }

    private void compare(ListValueModel<Junk> listValueModel, List<Junk> list) {
        ItemPropertyListValueModelAdapterTests.assertEquals((int)listValueModel.size(), (int)list.size());
        int i = 0;
        while (i < listValueModel.size()) {
            ItemPropertyListValueModelAdapterTests.assertEquals((Object)listValueModel.get(i), (Object)list.get(i));
            ++i;
        }
    }

    public void testCollectionSort() {
        this.verifyCollectionSort(null);
    }

    public void testListSort() {
        this.verifyListSort(null);
    }

    public void testCustomCollectionSort() {
        this.verifyCollectionSort(this.buildCustomComparator());
    }

    public void testCustomListSort() {
        this.verifyListSort(this.buildCustomComparator());
    }

    private Comparator<Junk> buildCustomComparator() {
        return new Comparator<Junk>(){

            @Override
            public int compare(Junk o1, Junk o2) {
                return o2.displayString().compareTo(o1.displayString());
            }
        };
    }

    private void verifyCollectionSort(Comparator<Junk> comparator) {
        SimpleCollectionValueModel<Junk> collectionHolder = this.buildCollectionHolder();
        ItemPropertyListValueModelAdapter listValueModel = new ItemPropertyListValueModelAdapter((ListValueModel)new SortedListValueModelAdapter(collectionHolder, comparator), new String[]{"displayString", "icon"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        collectionHolder.add((Object)this.tom);
        collectionHolder.add((Object)this.dick);
        collectionHolder.add((Object)this.harry);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        collectionHolder.remove((Object)this.foo);
        collectionHolder.remove((Object)this.jar);
        collectionHolder.remove((Object)this.harry);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        collectionHolder.setValues(this.buildCollection());
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
    }

    private void verifyListSort(Comparator<Junk> comparator) {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemPropertyListValueModelAdapter listValueModel = new ItemPropertyListValueModelAdapter((ListValueModel)new SortedListValueModelWrapper(listHolder, comparator), new String[]{"displayString", "icon"});
        CoordinatedList<Junk> synchList = new CoordinatedList<Junk>((ListValueModel<Junk>)listValueModel);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        listHolder.add(0, (Object)this.tom);
        listHolder.add(0, (Object)this.dick);
        listHolder.add(0, (Object)this.harry);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)9, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        listHolder.remove(8);
        listHolder.remove(4);
        listHolder.remove(0);
        listHolder.remove(5);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)5, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
        listHolder.setListValues(this.buildList());
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
        this.compareSort((ListValueModel<Junk>)listValueModel, synchList, comparator);
    }

    private void compareSort(ListValueModel<Junk> listValueModel, List<Junk> list, Comparator<Junk> comparator) {
        TreeSet<Junk> ss = new TreeSet<Junk>(comparator);
        int i = 0;
        while (i < listValueModel.size()) {
            ss.add((Junk)listValueModel.get(i));
            ++i;
        }
        ItemPropertyListValueModelAdapterTests.assertEquals((int)ss.size(), (int)list.size());
        Iterator stream1 = ss.iterator();
        Iterator<Junk> stream2 = list.iterator();
        while (stream1.hasNext()) {
            ItemPropertyListValueModelAdapterTests.assertEquals(stream1.next(), (Object)stream2.next());
        }
    }

    public void testHasListeners() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyPropertyChangeListeners("icon"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyPropertyChangeListeners("icon"));
        ItemPropertyListValueModelAdapter listValueModel = new ItemPropertyListValueModelAdapter((ListValueModel)new SortedListValueModelWrapper(listHolder), new String[]{"displayString", "icon"});
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyPropertyChangeListeners("icon"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyPropertyChangeListeners("icon"));
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)this.foo.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)this.foo.hasAnyPropertyChangeListeners("icon"));
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)this.jaz.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)this.jaz.hasAnyPropertyChangeListeners("icon"));
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        listValueModel.removeListChangeListener("list values", synchList);
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)listHolder.hasAnyListChangeListeners("list values"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.foo.hasAnyPropertyChangeListeners("icon"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyPropertyChangeListeners("displayString"));
        ItemPropertyListValueModelAdapterTests.assertFalse((boolean)this.jaz.hasAnyPropertyChangeListeners("icon"));
        this.verifyHasNoListeners((ListValueModel<Junk>)listValueModel);
    }

    public void testGetSize() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        ItemPropertyListValueModelAdapter listValueModel = new ItemPropertyListValueModelAdapter((ListValueModel)new SortedListValueModelWrapper(listHolder), new String[]{"displayString", "icon"});
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)listValueModel.size());
        ItemPropertyListValueModelAdapterTests.assertEquals((int)6, (int)synchList.size());
    }

    public void testGet() throws Exception {
        SimpleListValueModel<Junk> listHolder = this.buildListHolder();
        SortedListValueModelWrapper listValueModel = new SortedListValueModelWrapper((ListValueModel)new ItemPropertyListValueModelAdapter(listHolder, new String[]{"displayString", "icon"}));
        CoordinatedList synchList = new CoordinatedList(listValueModel);
        this.verifyHasListeners((ListValueModel<Junk>)listValueModel);
        ItemPropertyListValueModelAdapterTests.assertEquals((Object)this.bar, (Object)listValueModel.get(0));
        ItemPropertyListValueModelAdapterTests.assertEquals((Object)this.bar, synchList.get(0));
        this.bar.setName("zzz");
        ItemPropertyListValueModelAdapterTests.assertEquals((Object)this.bar, (Object)listValueModel.get(5));
        ItemPropertyListValueModelAdapterTests.assertEquals((Object)this.bar, synchList.get(5));
        this.bar.setName("this.bar");
    }

    private void verifyHasNoListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasNoListChangeListeners("list values"));
    }

    private void verifyHasListeners(ListValueModel<Junk> listValueModel) throws Exception {
        ItemPropertyListValueModelAdapterTests.assertTrue((boolean)((AbstractModel)listValueModel).hasAnyListChangeListeners("list values"));
    }

    private SimpleCollectionValueModel<Junk> buildCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildCollection());
    }

    private Collection<Junk> buildCollection() {
        HashBag bag = new HashBag();
        this.populateCollection((Collection<Junk>)bag);
        return bag;
    }

    private SimpleListValueModel<Junk> buildListHolder() {
        return new SimpleListValueModel(this.buildList());
    }

    private List<Junk> buildList() {
        ArrayList<Junk> list = new ArrayList<Junk>();
        this.populateCollection(list);
        return list;
    }

    private void populateCollection(Collection<Junk> c) {
        c.add(this.foo);
        c.add(this.bar);
        c.add(this.baz);
        c.add(this.joo);
        c.add(this.jar);
        c.add(this.jaz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Junk
    extends AbstractModel
    implements Displayable,
    Comparable<Junk> {
        private String name;

        public Junk(String name) {
            this.name = name;
        }

        public String displayString() {
            return this.name;
        }

        public Icon icon() {
            return null;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged("displayString", old, name);
        }

        @Override
        public int compareTo(Junk o) {
            return this.displayString().compareTo(o.displayString());
        }

        public String toString() {
            return "Junk(" + this.name + ")";
        }
    }
}

