/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.RadioButtonModelAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonModelAdapterTests
extends TestCase {
    private ModifiablePropertyValueModel<Object> valueHolder;
    private ButtonModel redButtonModelAdapter;
    private ChangeListener redListener;
    boolean redEventFired;
    private ButtonModel greenButtonModelAdapter;
    private ChangeListener greenListener;
    boolean greenEventFired;
    private ButtonModel blueButtonModelAdapter;
    private ChangeListener blueListener;
    boolean blueEventFired;
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String BLUE = "blue";

    public RadioButtonModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.valueHolder = new SimplePropertyValueModel(null);
        this.redButtonModelAdapter = this.buildButtonModel(this.valueHolder, RED);
        this.redListener = new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RadioButtonModelAdapterTests.this.redEventFired = true;
            }
        };
        this.greenButtonModelAdapter = this.buildButtonModel(this.valueHolder, GREEN);
        this.greenListener = new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RadioButtonModelAdapterTests.this.greenEventFired = true;
            }
        };
        this.blueButtonModelAdapter = this.buildButtonModel(this.valueHolder, BLUE);
        this.blueListener = new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RadioButtonModelAdapterTests.this.blueEventFired = true;
            }
        };
        this.clearFlags();
    }

    private ButtonModel buildButtonModel(ModifiablePropertyValueModel<Object> pvm, Object buttonValue) {
        return new RadioButtonModelAdapter(pvm, buttonValue){

            protected PropertyChangeListener buildBooleanChangeListener() {
                return this.buildBooleanChangeListener_();
            }
        };
    }

    private void listenToModelAdapters() {
        this.redButtonModelAdapter.addChangeListener(this.redListener);
        this.greenButtonModelAdapter.addChangeListener(this.greenListener);
        this.blueButtonModelAdapter.addChangeListener(this.blueListener);
    }

    private void clearFlags() {
        this.redEventFired = false;
        this.greenEventFired = false;
        this.blueEventFired = false;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSetSelected() throws Exception {
        this.listenToModelAdapters();
        this.greenButtonModelAdapter.setSelected(true);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertEquals((Object)GREEN, (Object)this.valueHolder.getValue());
        this.clearFlags();
        this.blueButtonModelAdapter.setSelected(true);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertEquals((Object)BLUE, (Object)this.valueHolder.getValue());
        this.clearFlags();
        this.redButtonModelAdapter.setSelected(true);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertEquals((Object)RED, (Object)this.valueHolder.getValue());
    }

    public void testSetValue() throws Exception {
        this.listenToModelAdapters();
        this.greenButtonModelAdapter.setSelected(true);
        this.clearFlags();
        this.valueHolder.setValue((Object)BLUE);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueButtonModelAdapter.isSelected());
        this.clearFlags();
        this.valueHolder.setValue((Object)RED);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.redButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.blueButtonModelAdapter.isSelected());
    }

    public void testDefaultValue() throws Exception {
        this.listenToModelAdapters();
        this.valueHolder.setValue((Object)GREEN);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertTrue((boolean)this.greenButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.blueButtonModelAdapter.isSelected());
        this.clearFlags();
        this.valueHolder.setValue(null);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.blueButtonModelAdapter.isSelected());
        this.clearFlags();
        this.valueHolder.setValue((Object)BLUE);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenEventFired);
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueEventFired);
        RadioButtonModelAdapterTests.assertFalse((boolean)this.redButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertFalse((boolean)this.greenButtonModelAdapter.isSelected());
        RadioButtonModelAdapterTests.assertTrue((boolean)this.blueButtonModelAdapter.isSelected());
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localValueHolder = (SimplePropertyValueModel)this.valueHolder;
        RadioButtonModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.redButtonModelAdapter);
        this.verifyHasNoListeners(this.greenButtonModelAdapter);
        this.verifyHasNoListeners(this.blueButtonModelAdapter);
        TestChangeListener listener = new TestChangeListener();
        this.redButtonModelAdapter.addChangeListener(listener);
        RadioButtonModelAdapterTests.assertTrue((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.redButtonModelAdapter);
        this.verifyHasNoListeners(this.greenButtonModelAdapter);
        this.verifyHasNoListeners(this.blueButtonModelAdapter);
        this.redButtonModelAdapter.removeChangeListener(listener);
        RadioButtonModelAdapterTests.assertFalse((boolean)localValueHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.redButtonModelAdapter);
        this.verifyHasNoListeners(this.greenButtonModelAdapter);
        this.verifyHasNoListeners(this.blueButtonModelAdapter);
    }

    private void verifyHasNoListeners(Object model) throws Exception {
        EventListenerList listenerList = (EventListenerList)ReflectionTools.getFieldValue((Object)model, (String)"listenerList");
        RadioButtonModelAdapterTests.assertEquals((int)0, (int)listenerList.getListenerList().length);
    }

    private void verifyHasListeners(Object model) throws Exception {
        EventListenerList listenerList = (EventListenerList)ReflectionTools.getFieldValue((Object)model, (String)"listenerList");
        RadioButtonModelAdapterTests.assertFalse((listenerList.getListenerList().length == 0 ? 1 : 0) != 0);
    }

    private class TestChangeListener
    implements ChangeListener {
        TestChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            RadioButtonModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

