/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.contentassist.CompletionProposoalCatigoriesConfigurationRegistry;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.sse.ui.preferences.CodeAssistCyclingConfigurationBlock;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class HTMLContentAssistPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    private static final String HTML_CONTENT_TYPE_ID = "org.eclipse.wst.html.core.htmlsource";
    private Button fAutoPropose;
    private Label fAutoProposeDelayLabel;
    private Text fAutoProposeDelay;
    private Label fAutoProposeLabel;
    private Text fAutoProposeText;
    private CodeAssistCyclingConfigurationBlock fConfigurationBlock;
    private Button fInsertSingleProposals;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        this.createContentsForInsertionGroup(composite);
        this.createContentsForAutoActivationGroup(composite);
        this.createContentsForCyclingGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private void createContentsForInsertionGroup(Composite composite) {
        Group group = this.createGroup(composite, 2);
        group.setText(XMLUIMessages.Group_label_Insertion);
        this.fInsertSingleProposals = this.createCheckBox((Composite)group, "Insert single proposals automatically");
        ((GridData)this.fInsertSingleProposals.getLayoutData()).horizontalSpan = 2;
    }

    protected void performDefaults() {
        this.performDefaultsForAutoActivationGroup();
        this.performDefaultsForCyclingGroup();
        this.performDefaultsForInsertionGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    private void performDefaultsForInsertionGroup() {
        this.defaultCheckbox(this.fInsertSingleProposals, "insertSingleSuggestion");
    }

    protected void initializeValues() {
        this.initializeValuesForAutoActivationGroup();
        this.initializeValuesForCyclingGroup();
        this.initializeValuesForInsertionGroup();
    }

    private void initializeValuesForInsertionGroup() {
        this.initCheckbox(this.fInsertSingleProposals, "insertSingleSuggestion");
    }

    protected void storeValues() {
        this.storeValuesForAutoActivationGroup();
        this.storeValuesForCyclingGroup();
        this.storeValuesForInsertionGroup();
    }

    private void storeValuesForInsertionGroup() {
        this.getPreferenceStore().setValue("insertSingleSuggestion", this.fInsertSingleProposals != null ? this.fInsertSingleProposals.getSelection() : false);
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeDelayLabel.setEnabled(true);
                this.fAutoProposeDelay.setEnabled(true);
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeDelayLabel.setEnabled(false);
                this.fAutoProposeDelay.setEnabled(false);
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return HTMLUIPlugin.getDefault().getPreferenceStore();
    }

    private void createContentsForAutoActivationGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(HTMLUIMessages.Auto_Activation_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, HTMLUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeDelayLabel = this.createLabel((Composite)contentAssistGroup, HTMLUIMessages.Auto_Activation_Delay);
        this.fAutoProposeDelay = this.createTextField((Composite)contentAssistGroup);
        this.fAutoProposeDelay.setTextLimit(4);
        this.fAutoProposeDelay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HTMLContentAssistPreferencePage.this.verifyDelay();
            }
        });
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, HTMLUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
    }

    private void verifyDelay() {
        String text = this.fAutoProposeDelay.getText();
        boolean valid = true;
        try {
            int delay = Integer.parseInt(text);
            if (delay < 0) {
                valid = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid) {
            if (text.trim().length() > 0) {
                this.setErrorMessage(NLS.bind((String)XMLUIMessages.Not_an_integer, (Object)text));
            } else {
                this.setErrorMessage(XMLUIMessages.Missing_integer);
            }
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private void createContentsForCyclingGroup(Composite parent) {
        ICompletionProposalCategoriesConfigurationWriter configurationWriter = CompletionProposoalCatigoriesConfigurationRegistry.getDefault().getWritableConfiguration(HTML_CONTENT_TYPE_ID);
        if (configurationWriter != null) {
            this.fConfigurationBlock = new CodeAssistCyclingConfigurationBlock(HTML_CONTENT_TYPE_ID, configurationWriter);
            this.fConfigurationBlock.createContents(parent, HTMLUIMessages.Cycling_UI_);
        } else {
            Logger.log((int)4, (String)"There should be an ICompletionProposalCategoriesConfigurationWriter specified for the HTML content type, but can't fine it, thus can't create user preference block for editing proposal categories preferences.");
        }
    }

    private void storeValuesForAutoActivationGroup() {
        this.getPreferenceStore().setValue(HTMLUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
        this.getPreferenceStore().setValue("autoProposeDelay", Integer.parseInt(this.fAutoProposeDelay.getText()));
    }

    private void storeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.storeValues();
        }
    }

    private void initializeValuesForAutoActivationGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE));
        this.fAutoProposeDelay.setText(Integer.toString(this.getPreferenceStore().getInt("autoProposeDelay")));
    }

    private void initializeValuesForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.initializeValues();
        }
    }

    private void performDefaultsForAutoActivationGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE));
        this.fAutoProposeDelay.setText(Integer.toString(this.getPreferenceStore().getDefaultInt("autoProposeDelay")));
    }

    private void performDefaultsForCyclingGroup() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }
}

