/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.util.HashMap;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ScriptSource;

public class Breakpoint {
    final Long breakpointId;
    final ScriptSource script;
    final Integer lineNumber;
    final Object functionName;
    final String condition;
    final Long threadId;

    public Breakpoint(Long breakpointId, ScriptSource script, Integer lineNumber, String functionName, String condition, Long threadId) {
        if (script == null) {
            throw new IllegalArgumentException("The parent script cannot be null");
        }
        this.breakpointId = breakpointId;
        this.script = script;
        this.lineNumber = lineNumber;
        this.functionName = functionName;
        this.condition = condition;
        this.threadId = threadId;
    }

    public Object toJSON() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("breakpointId", this.breakpointId);
        result.put("scriptId", this.script.getId());
        if (this.lineNumber != null) {
            result.put("line", this.lineNumber);
        }
        if (this.functionName != null) {
            result.put("function", this.functionName);
        }
        if (this.condition != null) {
            result.put("condition", this.condition);
        }
        if (this.threadId != null) {
            result.put("threadId", this.threadId);
        }
        return result;
    }

    public void delete() {
        this.script.removeBreakpoint(this);
    }
}

