/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.builder;

import java.util.logging.Level;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.jpa.core.internal.prefs.JpaPreferencesManager;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.LoggingLevel;

public class EclipseLinkStaticWeavingBuilderConfigurator
extends JpaPreferencesManager {
    public static final String BUILDER_ID = "org.eclipse.jpt.jpa.eclipselink.core.builder";
    private static final String STATIC_WEAVE_PREFIX = "staticweave.";
    public static final String SOURCE = "SOURCE";
    public static final String TARGET = "TARGET";
    public static final String LOG_LEVEL = "LOG_LEVEL";
    public static final String PERSISTENCE_INFO = "PERSISTENCE_INFO";

    public EclipseLinkStaticWeavingBuilderConfigurator(IProject project) {
        super(project);
    }

    public void addBuilder() {
        try {
            IProjectDescription description = this.getProject().getDescription();
            ICommand[] commands = description.getBuildSpec();
            ICommand newCommand = description.newCommand();
            newCommand.setBuilderName(BUILDER_ID);
            ICommand[] newCommands = null;
            if (commands != null) {
                newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 0, commands.length);
                newCommands[commands.length] = newCommand;
            } else {
                newCommands = new ICommand[]{newCommand};
            }
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean projectHasStaticWeavingBuilder() {
        try {
            IProjectDescription description = this.getProject().getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands.length == 0) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= commands.length) {
                    return false;
                }
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void removeBuilder() {
        try {
            IProjectDescription description = this.getProject().getDescription();
            ICommand[] commands = description.getBuildSpec();
            if (commands.length == 0) {
                return;
            }
            int newLength = 0;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    commands[i] = null;
                } else {
                    ++newLength;
                }
                ++i;
            }
            if (newLength == commands.length) {
                return;
            }
            ICommand[] newCommands = new ICommand[newLength];
            int i2 = 0;
            int j = 0;
            while (i2 < commands.length) {
                if (commands[i2] != null) {
                    newCommands[j++] = commands[i2];
                }
                ++i2;
            }
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, 0, null);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public String getSourceLocationPreference() {
        return this.getLegacyProjectPreference(this.appendPrefix(SOURCE), this.getDefaultSourceLocation());
    }

    public String getTargetLocationPreference() {
        return this.getLegacyProjectPreference(this.appendPrefix(TARGET), this.getDefaultTargetLocation());
    }

    public String getPersistenceInfoPreference() {
        return this.getLegacyProjectPreference(this.appendPrefix(PERSISTENCE_INFO), this.getDefaultPersistenceInfo());
    }

    public String getLogLevelPreference() {
        return this.getLegacyProjectPreference(this.appendPrefix(LOG_LEVEL), this.getDefaultLogLevel());
    }

    public String getDefaultSourceLocation() {
        return this.getJavaProjectOutputLocation();
    }

    public String getDefaultTargetLocation() {
        return this.getJavaProjectOutputLocation();
    }

    public String getDefaultPersistenceInfo() {
        return null;
    }

    public String getDefaultLogLevel() {
        return Level.SEVERE.getName();
    }

    public LoggingLevel[] getLogLevelValues() {
        return LoggingLevel.values();
    }

    public void setSourceLocationPreference(String location) {
        this.setLegacyProjectPreference(this.appendPrefix(SOURCE), location);
    }

    public void removeSourceLocationPreference() {
        this.setLegacyProjectPreference(this.appendPrefix(SOURCE), null);
    }

    public void setTargetLocationPreference(String location) {
        this.setLegacyProjectPreference(this.appendPrefix(TARGET), location);
    }

    public void removeTargetLocationPreference() {
        this.setLegacyProjectPreference(this.appendPrefix(TARGET), null);
    }

    public void setLogLevelPreference(String logLevel) {
        this.setLegacyProjectPreference(this.appendPrefix(LOG_LEVEL), logLevel);
    }

    public void removeLogLevelPreference() {
        this.setLegacyProjectPreference(this.appendPrefix(LOG_LEVEL), null);
    }

    public void setPersistenceInfoPreference(String persistenceInfo) {
        this.setLegacyProjectPreference(this.appendPrefix(PERSISTENCE_INFO), persistenceInfo);
    }

    public void removePersistenceInfoPreference() {
        this.setLegacyProjectPreference(this.appendPrefix(PERSISTENCE_INFO), null);
    }

    private String getJavaProjectOutputLocation() {
        try {
            return this.getJavaProjectOutputLocationPath().toOSString();
        }
        catch (CoreException coreException) {
            return ".";
        }
    }

    private IPath getJavaProjectOutputLocationPath() throws CoreException {
        IPath outputLocation = this.getJavaProject().getOutputLocation();
        String projectName = outputLocation.segment(0);
        if (this.getProject().getName().equals(projectName)) {
            outputLocation = outputLocation.removeFirstSegments(1);
        }
        return outputLocation;
    }

    private IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.getProject());
    }

    private String appendPrefix(String id) {
        return STATIC_WEAVE_PREFIX + id;
    }
}

