/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.jpql.spi;

import java.lang.annotation.Annotation;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeRepository;
import org.eclipse.jpt.jpa.eclipselink.core.jpql.spi.EclipseLinkDynamicManagedType;
import org.eclipse.jpt.jpa.eclipselink.core.jpql.spi.EclipseLinkMapping;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDynamicMapping
implements IMapping {
    private EclipseLinkMapping delegate;
    private EclipseLinkDynamicManagedType parent;
    private IType type;
    private ITypeDeclaration typeDeclaration;

    public EclipseLinkDynamicMapping(EclipseLinkDynamicManagedType parent, EclipseLinkMapping delegate) {
        this.parent = parent;
        this.delegate = delegate;
    }

    protected ITypeDeclaration[] buildGenericTypeDeclarations() {
        RelationshipMapping mapping;
        Entity targetEntity;
        if ((this.delegate.isRelationship() || this.delegate.isCollection()) && (targetEntity = (mapping = (RelationshipMapping)this.delegate.getMapping()).getResolvedTargetEntity()) != null) {
            IEntity entity = this.parent.getProvider().getEntityNamed(targetEntity.getName());
            return new ITypeDeclaration[]{entity.getType().getTypeDeclaration()};
        }
        return new ITypeDeclaration[0];
    }

    protected IType buildType() {
        IManagedType managedType;
        if ((this.delegate.isCollection() || this.delegate.isRelationship()) && (managedType = this.parent.getProvider().getManagedType(this.getTypeName())) != null) {
            return managedType.getType();
        }
        return this.getTypeRepository().getType(this.getTypeName());
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        String typeName = this.getTypeName();
        int dimensionality = 0;
        if (StringTools.stringIsNotEmpty((String)typeName)) {
            int index = typeName.indexOf("[]");
            dimensionality = (typeName.length() - index) / 2;
        }
        return new JpaTypeDeclaration(this.getType(), this.buildGenericTypeDeclarations(), dimensionality);
    }

    public int compareTo(IMapping mapping) {
        return this.delegate.compareTo(mapping);
    }

    public PersistentAttribute getAttribute() {
        return this.delegate.getMapping().getPersistentAttribute();
    }

    public int getMappingType() {
        return this.delegate.getMappingType();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public IManagedType getParent() {
        return this.parent;
    }

    public IType getType() {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    public String getTypeName() {
        return this.getAttribute().getTypeName();
    }

    protected JpaTypeRepository getTypeRepository() {
        return this.parent.getProvider().getTypeRepository();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.delegate.hasAnnotation(annotationType);
    }

    public boolean isCollection() {
        return this.delegate.isCollection();
    }

    public boolean isProperty() {
        return this.delegate.isProperty();
    }

    public boolean isRelationship() {
        return this.delegate.isRelationship();
    }

    public boolean isTransient() {
        return this.delegate.isTransient();
    }
}

