/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.prefs.JpaJpqlPreferencesManager;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlIdentifierMessages;
import org.eclipse.persistence.jpa.jpql.ContentAssistProposals;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JpqlCompletionProposalComputer<T> {
    String actualQuery;
    ContentAssistProposals contentAssistProposals;
    private ImageRegistry imageRegistry;
    String jpqlQuery;
    NamedQuery namedQuery;
    int offset;
    private String partialWord;
    int position;
    JpaJpqlQueryHelper queryHelper;

    private void addAbstractSchemaNames(List<T> proposals) {
        for (IEntity abstractSchemaType : this.sortByNames((Iterable<IEntity>)this.contentAssistProposals.abstractSchemaTypes())) {
            proposals.add(this.buildAbstractSchemaNameProposal(abstractSchemaType));
        }
    }

    private void addIdentificationVariables(List<T> proposals) {
        for (String variable : this.sort((Iterable)this.contentAssistProposals.identificationVariables())) {
            proposals.add(this.buildIdentificationVariableProposal(variable));
        }
    }

    private void addIdentifiers(List<T> proposals) {
        for (String identifier : this.sort((Iterable)this.contentAssistProposals.identifiers())) {
            proposals.add(this.buildIdentifierProposal(identifier));
        }
    }

    private String additionalInfo(String proposal) {
        return JpqlIdentifierMessages.localizedMessage(proposal);
    }

    private void addMappings(List<T> proposals) {
        for (IMapping mapping : this.sort((Iterable)this.contentAssistProposals.mappings())) {
            proposals.add(this.buildMappingProposal(mapping));
        }
    }

    private T buildAbstractSchemaNameProposal(IEntity abstractSchemaType) {
        String proposal = abstractSchemaType.getName();
        return this.buildProposal(proposal, proposal, this.entityImage());
    }

    private Comparator<IEntity> buildEntityNameComparator() {
        return new Comparator<IEntity>(){

            @Override
            public int compare(IEntity entity1, IEntity entity2) {
                return entity1.getName().compareTo(entity2.getName());
            }
        };
    }

    private String buildIdentificationVariableDisplayString(String identificationVariable) {
        IEntity abstractSchemaType = this.contentAssistProposals.getAbstractSchemaType(identificationVariable);
        if (abstractSchemaType != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(identificationVariable);
            sb.append(" : ");
            sb.append(abstractSchemaType.getName());
            identificationVariable = sb.toString();
        }
        return identificationVariable;
    }

    private T buildIdentificationVariableProposal(String proposal) {
        return this.buildProposal(proposal, this.buildIdentificationVariableDisplayString(proposal), this.identificationVariableImage());
    }

    private T buildIdentifierProposal(String proposal) {
        String additionalInfo = this.additionalInfo(proposal);
        IdentifierRole role = this.queryHelper.getQueryContext().getExpressionRegistry().getIdentifierRole(proposal);
        boolean realFunction = role == IdentifierRole.FUNCTION && this.isRealFunction(proposal);
        int cursorOffset = 0;
        if (this.partialWord.length() > 0 && this.shouldMatchFirstCharacterCase()) {
            if (Character.isLowerCase(this.partialWord.charAt(0))) {
                proposal = proposal.toLowerCase();
            }
        } else if (this.shouldUseLowercaseIdentifiers()) {
            proposal = proposal.toLowerCase();
        }
        if (realFunction) {
            proposal = String.valueOf(proposal) + "()";
            --cursorOffset;
        }
        return this.buildProposal(proposal, proposal, additionalInfo, this.identifierImage(realFunction), cursorOffset);
    }

    private T buildMappingProposal(IMapping mapping) {
        String proposal = mapping.getName();
        return this.buildProposal(proposal, proposal, this.mappingImage(mapping));
    }

    private T buildProposal(String proposal, String displayString, Image image) {
        return this.buildProposal(proposal, displayString, null, image, 0);
    }

    abstract T buildProposal(String var1, String var2, String var3, Image var4, int var5);

    final List<T> buildProposals(NamedQuery namedQuery, String actualQuery, int offset, int position) {
        try {
            this.offset = offset;
            this.actualQuery = actualQuery;
            this.namedQuery = namedQuery;
            int[] positions = new int[]{position};
            this.jpqlQuery = this.modifyJpqlQuery(actualQuery, positions);
            this.position = positions[0];
            this.partialWord = this.partialWord();
            if (this.queryHelper == null) {
                this.queryHelper = namedQuery.getPersistenceUnit().createJpqlQueryHelper();
            }
            this.queryHelper.setQuery(namedQuery, this.jpqlQuery);
            this.contentAssistProposals = this.queryHelper.buildContentAssistProposals(positions[0]);
            ArrayList proposals = new ArrayList();
            this.addAbstractSchemaNames(proposals);
            this.addIdentificationVariables(proposals);
            this.addIdentifiers(proposals);
            this.addMappings(proposals);
            ArrayList arrayList = proposals;
            return arrayList;
        }
        finally {
            this.clearInformation();
        }
    }

    final void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    final void clearInformation() {
        this.namedQuery = null;
        this.offset = -1;
        this.position = -1;
        this.actualQuery = null;
        this.namedQuery = null;
        this.partialWord = null;
        this.contentAssistProposals = null;
    }

    private Image entityImage() {
        return this.getImage("full/obj16/entity");
    }

    public String getErrorMessage() {
        return null;
    }

    private Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(String key) {
        return JptJpaUiPlugin.getImageDescriptor(key);
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry(Display.getCurrent());
        }
        return this.imageRegistry;
    }

    private Image identificationVariableImage() {
        return this.getImage("full/obj16/jpql.variable");
    }

    private Image identifierImage(boolean function) {
        if (function) {
            return this.getImage("full/obj16/jpql.function");
        }
        return this.getImage("full/obj16/jpql.identifier");
    }

    private boolean isRealFunction(String identifier) {
        return identifier != "TRUE" && identifier != "FALSE" && identifier != "NULL" && identifier != "CURRENT_DATE" && identifier != "CURRENT_TIME" && identifier != "CURRENT_TIMESTAMP";
    }

    private Image mappingImage(IMapping mapping) {
        switch (mapping.getMappingType()) {
            case 1: {
                return this.getImage("full/obj16/basic");
            }
            case 2: {
                return this.getImage("full/obj16/element-collection");
            }
            case 3: {
                return this.getImage("full/obj16/embedded");
            }
            case 4: {
                return this.getImage("full/obj16/embedded-id");
            }
            case 5: {
                return this.getImage("full/obj16/id");
            }
            case 6: {
                return this.getImage("full/obj16/many-to-many");
            }
            case 7: {
                return this.getImage("full/obj16/many-to-one");
            }
            case 8: {
                return this.getImage("full/obj16/one-to-many");
            }
            case 9: {
                return this.getImage("full/obj16/one-to-one");
            }
            case 11: {
                return this.getImage("full/obj16/version");
            }
        }
        return this.getImage("full/obj16/transient");
    }

    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        return jpqlQuery;
    }

    private String partialWord() {
        WordParser wordParser = new WordParser((CharSequence)this.jpqlQuery);
        wordParser.setPosition(this.position);
        return wordParser.partialWord();
    }

    public void sessionEnded() {
        this.queryHelper = null;
        this.clearInformation();
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
    }

    public void sessionStarted() {
    }

    private boolean shouldMatchFirstCharacterCase() {
        return JpaJpqlPreferencesManager.getMatchFirstCharacterCaseWorkspacePreference();
    }

    private boolean shouldUseLowercaseIdentifiers() {
        String value = JpaJpqlPreferencesManager.getIdentifiersCaseWorkspacePreference();
        return "lowercase".equals(value);
    }

    private <I extends Comparable<? super I>> Iterable<I> sort(Iterable<I> iterator) {
        return CollectionTools.sort(iterator);
    }

    private Iterable<IEntity> sortByNames(Iterable<IEntity> abstractSchemaTypes) {
        return CollectionTools.sort(abstractSchemaTypes, this.buildEntityNameComparator());
    }
}

