/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence.details;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitMappingFilesComposite
extends Pane<PersistenceUnit> {
    private ModifiablePropertyValueModel<MappingFileRef> selectedItemHolder;

    public PersistenceUnitMappingFilesComposite(Pane<? extends PersistenceUnit> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedItemHolder = this.buildSelectedItemHolder();
    }

    protected void addMappingFilesList(Composite container) {
        new AddRemoveListPane<PersistenceUnit>((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.selectedItemHolder, this.buildLabelProvider(), "org.eclipse.jpt.jpa.ui.persistence_general"){

            protected Composite addContainer(Composite parent) {
                parent = super.addContainer(parent);
                PersistenceUnitMappingFilesComposite.this.updateGridData(parent);
                return parent;
            }

            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                PersistenceUnitMappingFilesComposite.this.updateGridData(this.getContainer());
            }
        };
    }

    private void addJPAMappingDescriptor() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(this.buildValidator());
        dialog.setTitle(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_mappingFileDialog_title);
        dialog.setMessage(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_mappingFileDialog_message);
        dialog.addFilter((ViewerFilter)new XmlMappingFileViewerFilter(((PersistenceUnit)this.getSubject()).getJpaProject(), JptJpaCorePlugin.MAPPING_FILE_CONTENT_TYPE));
        dialog.setInput((Object)((PersistenceUnit)this.getSubject()).getJpaProject().getProject());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                IFile file = (IFile)result;
                IProject project = file.getProject();
                ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
                IPath runtimePath = locator.getRuntimePath(file.getFullPath());
                String fileName = runtimePath.toPortableString();
                if (!this.mappingFileRefExists(fileName)) {
                    MappingFileRef mappingFileRef = ((PersistenceUnit)this.getSubject()).addSpecifiedMappingFileRef(fileName);
                    this.selectedItemHolder.setValue((Object)mappingFileRef);
                }
                ++n2;
            }
        }
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnitMappingFilesComposite.this.addJPAMappingDescriptor();
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).removeSpecifiedMappingFileRef((MappingFileRef)item);
                    ++n2;
                }
            }
        };
    }

    protected Composite addContainer(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        Composite container = this.addPane(parent, (Layout)layout);
        this.updateGridData(container);
        return container;
    }

    private ListValueModel<MappingFileRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"fileName"});
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return JptJpaUiPlugin.getImage("full/obj16/jpa-file");
            }

            public String getText(Object element) {
                MappingFileRef mappingFileRef = (MappingFileRef)element;
                String name = mappingFileRef.getFileName();
                if (name == null) {
                    name = JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_ormNoName;
                }
                return name;
            }
        };
    }

    private ListValueModel<MappingFileRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, MappingFileRef>(this.getSubjectHolder(), new String[]{"specifiedMappingFileRefs"}){

            protected ListIterable<MappingFileRef> getListIterable() {
                return ((PersistenceUnit)this.subject).getSpecifiedMappingFileRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getSpecifiedMappingFileRefsSize();
            }
        };
    }

    private ModifiablePropertyValueModel<MappingFileRef> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private boolean mappingFileRefExists(String fileName) {
        for (MappingFileRef mappingFileRef : ((PersistenceUnit)this.getSubject()).getSpecifiedMappingFileRefs()) {
            if (!mappingFileRef.getFileName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private ISelectionStatusValidator buildValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.jpt.jpa.ui", "");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof IFolder) {
                        return new Status(4, "org.eclipse.jpt.jpa.ui", "");
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.jpt.jpa.ui", "");
            }
        };
    }

    private void updateGridData(Composite container) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        container.setLayoutData((Object)gridData);
    }
}

