/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.prefs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.prefs.JpaEntityGenPreferencesManager;
import org.eclipse.jpt.jpa.core.prefs.JpaJpqlPreferencesManager;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JpaPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private boolean lowercase;
    private Button lowerCaseRadioButton;
    private boolean matchFirstCharacterCase;
    private Button matchFirstCharacterCaseCheckBox;
    private Button upperCaseRadioButton;
    private Text defaultPackageText;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parent.setLayout((Layout)layout);
        Label description = new Label(parent, 0);
        description.setText(JptUiMessages.JpaPreferencesPage_description);
        this.addEntityGenGroup(parent);
        this.addJpqlEditorGroup(parent);
        Dialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void performDefaults() {
        String defaultPackage = JpaEntityGenPreferencesManager.getDefaultDefaultPackage();
        this.setDefaultPackage(defaultPackage);
        JpaEntityGenPreferencesManager.setDefaultPackageWorkspacePreference((String)defaultPackage);
        this.lowercase = this.isDefaultJpqlIdentifierLowercase();
        this.matchFirstCharacterCase = this.shouldDefaultMatchFirstCharacterCase();
        this.lowerCaseRadioButton.setSelection(this.lowercase);
        this.upperCaseRadioButton.setSelection(!this.lowercase);
        this.matchFirstCharacterCaseCheckBox.setSelection(this.matchFirstCharacterCase);
        super.performDefaults();
    }

    public boolean performOk() {
        JpaEntityGenPreferencesManager.setDefaultPackageWorkspacePreference((String)this.getDefaultPackage());
        JpaJpqlPreferencesManager.setIdentifiersCaseWorkspacePreference((String)this.jpqlIdentifierPreferenceValue());
        JpaJpqlPreferencesManager.setMatchFirstCharacterCaseWorkspacePreference((boolean)this.matchFirstCharacterCase);
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.migrateLegacyJpqlWorkspacePreferences();
        this.lowercase = this.shouldUseLowercaseIdentifiers();
        this.matchFirstCharacterCase = this.shouldMatchFirstCharacterCase();
    }

    private void addEntityGenGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(JptUiMessages.JpaPreferencesPage_entityGen);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.buildLabel((Composite)group, 1, JptUiMessages.JpaPreferencesPage_entityGen_defaultPackageLabel);
        this.defaultPackageText = this.buildText((Composite)group, 1);
        this.defaultPackageText.setText(JpaEntityGenPreferencesManager.getDefaultPackageWorkspacePreference());
    }

    private void addJpqlEditorGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Label description = new Label((Composite)group, 0);
        description.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_description);
        this.lowerCaseRadioButton = new Button((Composite)group, 16);
        this.lowerCaseRadioButton.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_lowerCaseRadioButton);
        this.lowerCaseRadioButton.addSelectionListener(this.buildLowercaseSelectionListener());
        this.lowerCaseRadioButton.setSelection(this.lowercase);
        this.upperCaseRadioButton = new Button((Composite)group, 16);
        this.upperCaseRadioButton.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_upperCaseRadioButton);
        this.upperCaseRadioButton.addSelectionListener(this.buildUppercaseSelectionListener());
        this.upperCaseRadioButton.setSelection(!this.lowercase);
        new Label((Composite)group, 0);
        this.matchFirstCharacterCaseCheckBox = new Button((Composite)group, 32);
        this.matchFirstCharacterCaseCheckBox.setText(JptUiMessages.JpaPreferencesPage_jpqlEditor_matchFirstCharacterCaseRadioButton);
        this.matchFirstCharacterCaseCheckBox.addSelectionListener(this.buildMatchFirstCharacterCaseSelectionListener());
        this.matchFirstCharacterCaseCheckBox.setSelection(this.matchFirstCharacterCase);
    }

    private SelectionListener buildLowercaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.lowercase = button.getSelection();
            }
        };
    }

    private SelectionListener buildMatchFirstCharacterCaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.matchFirstCharacterCase = button.getSelection();
            }
        };
    }

    private SelectionListener buildUppercaseSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JpaPreferencesPage.this.lowercase = !button.getSelection();
            }
        };
    }

    private boolean isDefaultJpqlIdentifierLowercase() {
        String value = JpaJpqlPreferencesManager.getDefaultIdentifiersCase();
        return "lowercase".equals(value);
    }

    private String jpqlIdentifierPreferenceValue() {
        return this.lowercase ? "lowercase" : "uppercase";
    }

    private boolean shouldDefaultMatchFirstCharacterCase() {
        return JpaJpqlPreferencesManager.getDefaultMatchFirstCharacterCase();
    }

    private boolean shouldMatchFirstCharacterCase() {
        return JpaJpqlPreferencesManager.getMatchFirstCharacterCaseWorkspacePreference();
    }

    private boolean shouldUseLowercaseIdentifiers() {
        String value = JpaJpqlPreferencesManager.getIdentifiersCaseWorkspacePreference();
        return "lowercase".equals(value);
    }

    private String getDefaultPackage() {
        if (this.defaultPackageText == null) {
            return null;
        }
        return StringTools.stringIsEmpty((String)this.defaultPackageText.getText()) ? null : this.defaultPackageText.getText();
    }

    private void setDefaultPackage(String defaultPackage) {
        if (this.defaultPackageText == null) {
            return;
        }
        this.defaultPackageText.setText(defaultPackage);
    }

    private void migrateLegacyJpqlWorkspacePreferences() {
        IPreferenceStore preferences = JptJpaUiPlugin.instance().getPreferenceStore();
        String legacyCase = preferences.getString("org.eclipse.jpt.jpa.ui.jpqlIdentifier.case");
        boolean legacyMatchFirstCharacterCase = preferences.getBoolean("org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase");
        if (!StringTools.stringIsEmpty((String)legacyCase)) {
            JpaJpqlPreferencesManager.setIdentifiersCaseWorkspacePreference((String)legacyCase);
        }
        if (legacyMatchFirstCharacterCase) {
            JpaJpqlPreferencesManager.setMatchFirstCharacterCaseWorkspacePreference((boolean)legacyMatchFirstCharacterCase);
        }
        this.removeLegacyJpqlPreferences();
    }

    private void removeLegacyJpqlPreferences() {
        IPreferenceStore preferences = JptJpaUiPlugin.instance().getPreferenceStore();
        preferences.setToDefault("org.eclipse.jpt.jpa.ui.jpqlIdentifier.case");
        preferences.setToDefault("org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase");
    }

    private Text buildText(Composite parent, int horizontalSpan) {
        Text text = new Text(parent, 2052);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = horizontalSpan;
        text.setLayoutData((Object)gridData);
        return text;
    }

    private Label buildLabel(Composite parent, int span, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        return label;
    }
}

