/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementPropertyValueModelAdapter<V>
extends CollectionPropertyValueModelAdapter<V, V> {
    protected final Filter<V> predicate;

    public ElementPropertyValueModelAdapter(CollectionValueModel<? extends V> collectionModel, Filter<V> predicate) {
        super(collectionModel);
        if (predicate == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
    }

    @Override
    protected V buildValue() {
        for (Object each : this.collectionModel) {
            if (!this.predicate.accept(each)) continue;
            return (V)each;
        }
        return null;
    }

    @Override
    protected void itemsAdded(Iterable<V> items) {
        if (this.value == null) {
            this.itemsAdded_(items);
        }
    }

    protected void itemsAdded_(Iterable<V> items) {
        for (V each : items) {
            if (!this.predicate.accept(each)) continue;
            this.value = each;
            this.firePropertyChanged("value", null, this.value);
            return;
        }
    }

    @Override
    protected void itemsRemoved(Iterable<V> items) {
        if (this.value != null) {
            this.itemsRemoved_(items);
        }
    }

    protected void itemsRemoved_(Iterable<V> items) {
        for (V each : items) {
            if (!this.valuesAreEqual(each, this.value)) continue;
            Object old = this.value;
            this.value = null;
            this.firePropertyChanged("value", old, null);
            return;
        }
    }

    @Override
    protected void collectionCleared(CollectionClearEvent event) {
        if (this.value != null) {
            Object old = this.value;
            this.value = null;
            this.firePropertyChanged("value", old, null);
        }
    }

    @Override
    protected void collectionChanged(CollectionChangeEvent event) {
        Object old = this.value;
        this.value = this.buildValue();
        this.firePropertyChanged("value", old, this.value);
    }
}

