/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.context;

import java.util.Collection;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;

public interface Accessor
extends JavaContextNode {
    public JavaResourceAttribute getJavaResourceAttribute();

    public boolean isFor(JavaResourceField var1);

    public boolean isFor(JavaResourceMethod var1, JavaResourceMethod var2);

    public String getJavaResourceAttributeBaseTypeName();

    public boolean isJavaResourceAttributeCollectionType();

    public boolean isJavaResourceAttributeTypeSubTypeOf(String var1);

    public static final class AccessorTools {
        public static final String BYTE_ARRAY_CLASS_NAME = "byte[]";
        public static final String COLLECTION_CLASS_NAME = Collection.class.getName();
        public static final String OBJECT_CLASS_NAME = Object.class.getName();

        public static String getBaseTypeName(JavaResourceAttribute attribute) {
            if (attribute.typeIsArray()) {
                if (BYTE_ARRAY_CLASS_NAME.equals(attribute.getTypeName())) {
                    return BYTE_ARRAY_CLASS_NAME;
                }
                if (attribute.getTypeArrayDimensionality() == 1) {
                    return attribute.getTypeArrayComponentTypeName();
                }
            } else if (attribute.typeIsSubTypeOf(COLLECTION_CLASS_NAME)) {
                if (attribute.getTypeTypeArgumentNamesSize() == 1) {
                    return attribute.getTypeTypeArgumentName(0);
                }
                return OBJECT_CLASS_NAME;
            }
            return attribute.getTypeName();
        }

        public static boolean isCollectionType(JavaResourceAttribute attribute) {
            if (attribute.typeIsArray()) {
                return attribute.getTypeArrayDimensionality() == 1 && !BYTE_ARRAY_CLASS_NAME.equals(attribute.getTypeName());
            }
            return attribute.typeIsSubTypeOf(COLLECTION_CLASS_NAME);
        }
    }
}

