/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Bag;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlElementsMapping;
import org.eclipse.jpt.jaxb.core.context.XmlIDREF;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAdaptableAttributeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElement;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlIDREF;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlElementsMapping
extends AbstractJavaAdaptableAttributeMapping<XmlElementsAnnotation>
implements XmlElementsMapping {
    protected final AbstractJaxbNode.ContextListContainer<XmlElement, XmlElementAnnotation> xmlElementContainer = this.buildXmlElementContainer();
    protected XmlElementWrapper xmlElementWrapper;
    protected XmlIDREF xmlIDREF;

    public GenericJavaXmlElementsMapping(JaxbPersistentAttribute parent) {
        super(parent);
        this.initializeXmlElementWrapper();
        this.initializeXmlIDREF();
    }

    @Override
    public String getKey() {
        return "xml-elements";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElements";
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlElementContainer.synchronizeWithResourceModel();
        this.syncXmlElementWrapper();
        this.syncXmlIDREF();
    }

    @Override
    public void update() {
        super.update();
        this.xmlElementContainer.update();
        this.updateXmlElementWrapper();
        this.updateXmlIDREF();
    }

    @Override
    public ListIterable<XmlElement> getXmlElements() {
        return this.xmlElementContainer.getContextElements();
    }

    @Override
    public int getXmlElementsSize() {
        return this.xmlElementContainer.getContextElementsSize();
    }

    @Override
    public XmlElement addXmlElement(int index) {
        XmlElementAnnotation annotation = ((XmlElementsAnnotation)this.getAnnotation()).addXmlElement(index);
        return (XmlElement)this.xmlElementContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeXmlElement(int index) {
        ((XmlElementsAnnotation)this.getAnnotation()).removeXmlElement(index);
        this.xmlElementContainer.removeContextElement(index);
    }

    @Override
    public void removeXmlElement(XmlElement xmlElement) {
        this.removeXmlElement(this.xmlElementContainer.indexOfContextElement(xmlElement));
    }

    @Override
    public void moveXmlElement(int targetIndex, int sourceIndex) {
        ((XmlElementsAnnotation)this.getAnnotation()).moveXmlElement(targetIndex, sourceIndex);
        this.xmlElementContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected XmlElement buildXmlElement(XmlElementAnnotation xmlElementAnnotation) {
        return new GenericJavaXmlElement(this, new XmlElementContext(xmlElementAnnotation));
    }

    protected ListIterable<XmlElementAnnotation> getXmlElementAnnotations() {
        return ((XmlElementsAnnotation)this.getAnnotation()).getXmlElements();
    }

    @Override
    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    @Override
    public XmlElementWrapper addXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapper xmlElementWrapper = this.buildXmlElementWrapper();
        this.setXmlElementWrapper_(xmlElementWrapper);
        return xmlElementWrapper;
    }

    @Override
    public void removeXmlElementWrapper() {
        if (this.xmlElementWrapper == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        this.setXmlElementWrapper_(null);
    }

    protected void setXmlElementWrapper_(XmlElementWrapper xmlElementWrapper) {
        XmlElementWrapper oldXmlElementWrapper = this.xmlElementWrapper;
        this.xmlElementWrapper = xmlElementWrapper;
        this.firePropertyChanged("xmlElementWrapper", oldXmlElementWrapper, xmlElementWrapper);
    }

    protected XmlElementWrapper buildXmlElementWrapper() {
        return new GenericJavaXmlElementWrapper(this, new GenericJavaXmlElementWrapper.SimpleContext(this.getXmlElementWrapperAnnotation()));
    }

    protected XmlElementWrapperAnnotation getXmlElementWrapperAnnotation() {
        return (XmlElementWrapperAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    protected void initializeXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            this.xmlElementWrapper = this.buildXmlElementWrapper();
        }
    }

    protected void syncXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            if (this.xmlElementWrapper != null) {
                this.xmlElementWrapper.synchronizeWithResourceModel();
            } else {
                this.setXmlElementWrapper_(this.buildXmlElementWrapper());
            }
        } else {
            this.setXmlElementWrapper_(null);
        }
    }

    protected void updateXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.update();
        }
    }

    protected AbstractJaxbNode.ContextListContainer<XmlElement, XmlElementAnnotation> buildXmlElementContainer() {
        XmlElementContainer container = new XmlElementContainer();
        container.initialize();
        return container;
    }

    @Override
    public XmlIDREF getXmlIDREF() {
        return this.xmlIDREF;
    }

    protected void setXmlIDREF_(XmlIDREF xmlIDREF) {
        XmlIDREF oldXmlIDREF = this.xmlIDREF;
        this.xmlIDREF = xmlIDREF;
        this.firePropertyChanged("xmlIDREF", oldXmlIDREF, xmlIDREF);
    }

    @Override
    public XmlIDREF addXmlIDREF() {
        if (this.xmlIDREF != null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlIDREF");
        XmlIDREF xmlIDREF = this.buildXmlIDREF();
        this.setXmlIDREF_(xmlIDREF);
        return xmlIDREF;
    }

    @Override
    public void removeXmlIDREF() {
        if (this.xmlIDREF == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlIDREF");
        this.setXmlIDREF_(null);
    }

    protected void initializeXmlIDREF() {
        if (this.getXmlIDREFAnnotation() != null) {
            this.xmlIDREF = this.buildXmlIDREF();
        }
    }

    protected void syncXmlIDREF() {
        if (this.getXmlIDREFAnnotation() == null) {
            this.setXmlIDREF_(null);
        } else if (this.xmlIDREF == null) {
            this.setXmlIDREF_(this.buildXmlIDREF());
        } else {
            this.xmlIDREF.synchronizeWithResourceModel();
        }
    }

    protected void updateXmlIDREF() {
        if (this.xmlIDREF != null) {
            this.xmlIDREF.update();
        }
    }

    protected XmlIDREFAnnotation getXmlIDREFAnnotation() {
        return (XmlIDREFAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlIDREF");
    }

    protected XmlIDREF buildXmlIDREF() {
        return new GenericJavaXmlIDREF(this, this.buildXmlIDREFContext());
    }

    protected XmlIDREFContext buildXmlIDREFContext() {
        return new XmlIDREFContext();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return new CompositeIterable(new Iterable[]{super.getReferencedXmlTypeNames(), new CompositeIterable((Iterable)new TransformationIterable<XmlElement, Iterable<String>>(this.getXmlElements()){

            protected Iterable<String> transform(XmlElement o) {
                return o.getReferencedXmlTypeNames();
            }
        })});
    }

    @Override
    public boolean isParticleMapping() {
        return true;
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        for (XmlElement xmlElement : this.getXmlElements()) {
            result = xmlElement.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        if (this.xmlElementWrapper != null && !CollectionTools.isEmpty(result = this.xmlElementWrapper.getJavaCompletionProposals(pos, filter, astRoot))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateDuplicateTypesAndQNames(messages, reporter, astRoot);
        for (XmlElement xmlElement : this.getXmlElements()) {
            xmlElement.validate(messages, reporter, astRoot);
        }
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.validate(messages, reporter, astRoot);
        }
        if (this.xmlIDREF != null) {
            this.xmlIDREF.validate(messages, reporter, astRoot);
        }
    }

    protected void validateDuplicateTypesAndQNames(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        HashBag xmlElementTypes = new HashBag();
        HashBag xmlElementQNames = new HashBag();
        for (XmlElement xmlElement : this.getXmlElements()) {
            String elementName;
            String typeName = xmlElement.getFullyQualifiedType();
            if (!StringTools.stringIsEmpty((String)typeName)) {
                xmlElementTypes.add((Object)typeName);
            }
            if (StringTools.stringIsEmpty((String)(elementName = xmlElement.getQName().getName()))) continue;
            xmlElementQNames.add((Object)new QName(xmlElement.getQName().getNamespace(), elementName));
        }
        for (XmlElement xmlElement : this.getXmlElements()) {
            this.validateDuplicateType(xmlElement, (Bag<String>)xmlElementTypes, messages, astRoot);
            this.validateDuplicateQName(xmlElement, (Bag<QName>)xmlElementQNames, messages, astRoot);
        }
    }

    protected void validateDuplicateType(XmlElement xmlElement, Bag<String> xmlElementTypes, List<IMessage> messages, CompilationUnit astRoot) {
        String xmlElementType = xmlElement.getFullyQualifiedType();
        if (xmlElementTypes.count((Object)xmlElementType) > 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENTS__DUPLICATE_XML_ELEMENT_TYPE", new String[]{xmlElementType}, xmlElement, xmlElement.getTypeTextRange(astRoot)));
        }
    }

    protected void validateDuplicateQName(XmlElement xmlElement, Bag<QName> xmlElementQNames, List<IMessage> messages, CompilationUnit astRoot) {
        String xmlElementName;
        String xmlElementNamespace = xmlElement.getQName().getNamespace();
        if (xmlElementQNames.count((Object)new QName(xmlElementNamespace, xmlElementName = xmlElement.getQName().getName())) > 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENTS__DUPLICATE_XML_ELEMENT_QNAME", new String[]{xmlElementName}, xmlElement, xmlElement.getQName().getNameTextRange(astRoot)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementContainer
    extends AbstractJaxbNode.ContextListContainer<XmlElement, XmlElementAnnotation> {
        protected XmlElementContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "xmlElements";
        }

        @Override
        protected XmlElement buildContextElement(XmlElementAnnotation resourceElement) {
            return GenericJavaXmlElementsMapping.this.buildXmlElement(resourceElement);
        }

        @Override
        protected ListIterable<XmlElementAnnotation> getResourceElements() {
            return GenericJavaXmlElementsMapping.this.getXmlElementAnnotations();
        }

        @Override
        protected XmlElementAnnotation getResourceElement(XmlElement contextElement) {
            return contextElement.getAnnotation(false);
        }
    }

    protected class XmlElementContext
    implements GenericJavaXmlElement.Context {
        protected XmlElementAnnotation annotation;

        protected XmlElementContext(XmlElementAnnotation annotation) {
            this.annotation = annotation;
        }

        public XmlElementAnnotation getAnnotation(boolean createIfNull) {
            return this.annotation;
        }

        public JaxbAttributeMapping getAttributeMapping() {
            return GenericJavaXmlElementsMapping.this;
        }

        public String getDefaultType() {
            return null;
        }

        public XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementsMapping.this.getXmlElementWrapper();
        }

        public boolean hasXmlID() {
            return false;
        }

        public boolean hasXmlIDREF() {
            return GenericJavaXmlElementsMapping.this.getXmlIDREF() != null;
        }

        public boolean hasXmlList() {
            return false;
        }

        public boolean hasXmlSchemaType() {
            return false;
        }

        public XmlSchemaType getXmlSchemaType() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlIDREFContext
    implements GenericJavaXmlIDREF.Context {
        protected XmlIDREFContext() {
        }

        @Override
        public XmlIDREFAnnotation getAnnotation() {
            return GenericJavaXmlElementsMapping.this.getXmlIDREFAnnotation();
        }

        @Override
        public Iterable<GenericJavaXmlIDREF.ValidatableReference> getReferences() {
            return new TransformationIterable<XmlElement, GenericJavaXmlIDREF.ValidatableReference>(GenericJavaXmlElementsMapping.this.getXmlElements()){

                protected GenericJavaXmlIDREF.ValidatableReference transform(final XmlElement o) {
                    return new GenericJavaXmlIDREF.ValidatableReference(){

                        public String getFullyQualifiedType() {
                            return o.getFullyQualifiedType();
                        }

                        public TextRange getTypeTextRange(CompilationUnit astRoot) {
                            return o.getTypeTextRange(astRoot);
                        }

                        public XsdFeature getXsdFeature() {
                            return o.getXsdElement();
                        }

                        public TextRange getXsdFeatureTextRange(CompilationUnit astRoot) {
                            return o.getQName().getNameTextRange(astRoot);
                        }
                    };
                }
            };
        }

        @Override
        public boolean isList() {
            return false;
        }
    }
}

