/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;

public class PersistentAttributePropertyTester
extends PropertyTester {
    public static final String IS_MAPPED = "isMapped";
    public static final String IS_NOT_MAPPED = "isNotMapped";
    public static final String IS_VIRTUAL = "isVirtual";
    public static final String IS_NOT_VIRTUAL = "isNotVirtual";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof ReadOnlyPersistentAttribute) {
            return this.test((ReadOnlyPersistentAttribute)receiver, property, expectedValue);
        }
        return false;
    }

    protected boolean test(ReadOnlyPersistentAttribute attribute, String property, Object expectedValue) {
        if (property.equals(IS_NOT_MAPPED)) {
            return !this.test(attribute, IS_MAPPED, expectedValue);
        }
        if (property.equals(IS_MAPPED)) {
            boolean actual;
            boolean expected = expectedValue == null ? true : (Boolean)expectedValue;
            boolean bl = actual = attribute.getMapping().getKey() != null;
            return actual == expected;
        }
        if (property.equals(IS_NOT_VIRTUAL)) {
            return !this.test(attribute, IS_VIRTUAL, expectedValue);
        }
        if (property.equals(IS_VIRTUAL)) {
            boolean expected = expectedValue == null ? true : (Boolean)expectedValue;
            boolean actual = attribute.isVirtual();
            return actual == expected;
        }
        return false;
    }
}

