/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.VirtualNamedColumn;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmNamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmVirtualNamedColumn<O extends ReadOnlyNamedColumn.Owner, C extends ReadOnlyNamedColumn>
extends AbstractOrmXmlContextNode
implements VirtualNamedColumn,
OrmReadOnlyNamedColumn {
    protected final O owner;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;

    protected AbstractOrmVirtualNamedColumn(XmlContextNode parent, O owner) {
        super(parent);
        this.owner = owner;
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedName(this.buildSpecifiedName());
        this.setDefaultName(this.buildDefaultName());
        this.setColumnDefinition(this.buildColumnDefinition());
    }

    public abstract C getOverriddenColumn();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    protected void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getOverriddenColumn().getSpecifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.owner.getDefaultColumnName(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    protected void setColumnDefinition(String columnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    protected String buildColumnDefinition() {
        return this.getOverriddenColumn().getColumnDefinition();
    }

    protected Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.owner.resolveDbTable(this.getTable());
    }

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildColumnValidator().validate(messages, reporter);
    }

    protected JptValidator buildColumnValidator() {
        return this.owner.buildColumnValidator(this, this.buildTextRangeResolver());
    }

    protected NamedColumnTextRangeResolver buildTextRangeResolver() {
        return new OrmNamedColumnTextRangeResolver(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange();
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public void toString(StringBuilder sb) {
        String table = this.getTable();
        if (table != null) {
            sb.append(table);
            sb.append('.');
        }
        sb.append(this.getName());
    }
}

