/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyRelationship;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualOverrideRelationship;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmVirtualOverrideJoinColumnRelationshipStrategy
extends AbstractOrmXmlContextNode
implements OrmVirtualJoinColumnRelationshipStrategy {
    protected final AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> specifiedJoinColumnContainer;
    protected final OrmReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmVirtualJoinColumn defaultJoinColumn;

    public GenericOrmVirtualOverrideJoinColumnRelationshipStrategy(OrmVirtualOverrideRelationship parent) {
        super(parent);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterable<OrmVirtualJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterable<OrmVirtualJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public OrmVirtualJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    protected void updateSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.update();
    }

    protected ListIterable<ReadOnlyJoinColumn> getOverriddenSpecifiedJoinColumns() {
        ReadOnlyJoinColumnRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? EmptyListIterable.instance() : new SuperListIterableWrapper(overriddenStrategy.getSpecifiedJoinColumns());
    }

    protected AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> buildSpecifiedJoinColumnContainer() {
        return new SpecifiedJoinColumnContainer();
    }

    protected OrmReadOnlyJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public OrmVirtualJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmVirtualJoinColumn joinColumn) {
        OrmVirtualJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmVirtualJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        ReadOnlyJoinColumn overriddenDefaultJoinColumn = this.getOverriddenDefaultJoinColumn();
        if (overriddenDefaultJoinColumn == null) {
            if (this.defaultJoinColumn != null) {
                this.setDefaultJoinColumn(null);
            }
        } else if (this.defaultJoinColumn != null && this.defaultJoinColumn.getOverriddenColumn() == overriddenDefaultJoinColumn) {
            this.defaultJoinColumn.update();
        } else {
            this.setDefaultJoinColumn(this.buildJoinColumn(overriddenDefaultJoinColumn));
        }
    }

    protected ReadOnlyJoinColumn getOverriddenDefaultJoinColumn() {
        ReadOnlyJoinColumnRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? null : overriddenStrategy.getDefaultJoinColumn();
    }

    @Override
    public OrmVirtualOverrideRelationship getParent() {
        return (OrmVirtualOverrideRelationship)super.getParent();
    }

    @Override
    public OrmVirtualOverrideRelationship getRelationship() {
        return this.getParent();
    }

    protected ReadOnlyJoinColumnRelationshipStrategy getOverriddenStrategy() {
        ReadOnlyJoinColumnRelationship relationship = this.getOverriddenJoinColumnRelationship();
        return relationship == null ? null : relationship.getJoinColumnStrategy();
    }

    protected ReadOnlyJoinColumnRelationship getOverriddenJoinColumnRelationship() {
        ReadOnlyRelationship relationship = this.resolveOverriddenRelationship();
        return relationship instanceof ReadOnlyJoinColumnRelationship ? (ReadOnlyJoinColumnRelationship)relationship : null;
    }

    protected ReadOnlyRelationship resolveOverriddenRelationship() {
        return this.getRelationship().resolveOverriddenRelationship();
    }

    @Override
    public boolean isTargetForeignKey() {
        RelationshipMapping relationshipMapping = this.getRelationshipMapping();
        return relationshipMapping != null && relationshipMapping.getRelationship().isTargetForeignKey();
    }

    @Override
    public TypeMapping getRelationshipSource() {
        return this.isTargetForeignKey() ? this.getRelationshipMapping().getResolvedTargetEntity() : this.getRelationship().getTypeMapping();
    }

    @Override
    public TypeMapping getRelationshipTarget() {
        return this.isTargetForeignKey() ? this.getRelationship().getTypeMapping() : this.getRelationshipMappingTargetEntity();
    }

    protected TypeMapping getRelationshipMappingTargetEntity() {
        RelationshipMapping mapping = this.getRelationshipMapping();
        return mapping == null ? null : mapping.getResolvedTargetEntity();
    }

    protected Entity getRelationshipTargetEntity() {
        TypeMapping target = this.getRelationshipTarget();
        return target instanceof Entity ? (Entity)target : null;
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        return this.isTargetForeignKey() ? this.getTargetDefaultTableName() : this.getRelationship().getDefaultTableName();
    }

    protected String getTargetDefaultTableName() {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.isTargetForeignKey() ? this.resolveTargetDbTable(tableName) : this.getRelationship().resolveDbTable(tableName);
    }

    protected Table resolveTargetDbTable(String tableName) {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    protected boolean tableNameIsInvalid(String tableName) {
        return this.isTargetForeignKey() ? this.targetTableNameIsInvalid(tableName) : this.getRelationship().tableNameIsInvalid(tableName);
    }

    protected boolean targetTableNameIsInvalid(String tableName) {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    protected Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterable<String> getCandidateTableNames() {
        return this.isTargetForeignKey() ? this.getTargetCandidateTableNames() : this.getRelationship().getCandidateTableNames();
    }

    protected Iterable<String> getTargetCandidateTableNames() {
        Entity typeMapping = this.getRelationshipMapping().getResolvedTargetEntity();
        return typeMapping != null ? typeMapping.getAllAssociatedTableNames() : EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationship().getValidationTextRange();
    }

    protected String getAttributeName() {
        return this.getRelationship().getAttributeName();
    }

    protected OrmVirtualJoinColumn buildJoinColumn(ReadOnlyJoinColumn overriddenJoinColumn) {
        return this.getContextNodeFactory().buildOrmVirtualJoinColumn(this, this.joinColumnOwner, overriddenJoinColumn);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (OrmVirtualJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinColumnOwner
    implements OrmReadOnlyJoinColumn.Owner {
        protected JoinColumnOwner() {
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getTableName();
        }

        @Override
        public String getDefaultColumnName(ReadOnlyNamedColumn column) {
            return MappingTools.buildJoinColumnDefaultName((ReadOnlyJoinColumn)column, this);
        }

        @Override
        public String getAttributeName() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getAttributeName();
        }

        @Override
        public Entity getRelationshipTarget() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getRelationshipTargetEntity();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Iterable<String> getCandidateTableNames() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getCandidateTableNames();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.resolveDbTable(tableName);
        }

        @Override
        public Table getReferencedColumnDbTable() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getReferencedColumnDbTable();
        }

        @Override
        public int getJoinColumnsSize() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getJoinColumnsSize();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getValidationTextRange();
        }

        @Override
        public JptValidator buildColumnValidator(ReadOnlyNamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getRelationship().buildColumnValidator((ReadOnlyBaseColumn)column, this, (TableColumnTextRangeResolver)textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected OrmVirtualJoinColumn buildContextElement(ReadOnlyJoinColumn resourceElement) {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<ReadOnlyJoinColumn> getResourceElements() {
            return GenericOrmVirtualOverrideJoinColumnRelationshipStrategy.this.getOverriddenSpecifiedJoinColumns();
        }

        @Override
        protected ReadOnlyJoinColumn getResourceElement(OrmVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

