/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.persistence.options;

import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceUnitProperties;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.JpaOptions2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOptions2_0
extends AbstractPersistenceUnitProperties
implements JpaOptions2_0 {
    private Integer lockTimeout;
    private Integer queryTimeout;
    private List<String> validationGroupPrePersists;
    private List<String> validationGroupPreUpdates;
    private List<String> validationGroupPreRemoves;

    public GenericOptions2_0(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void initializeProperties() {
        this.lockTimeout = this.getIntegerValue("javax.persistence.lock.timeout");
        this.queryTimeout = this.getIntegerValue("javax.persistence.query.timeout");
        this.validationGroupPrePersists = this.getCompositeValue("javax.persistence.validation.group.pre-persist");
        this.validationGroupPreUpdates = this.getCompositeValue("javax.persistence.validation.group.pre-update");
        this.validationGroupPreRemoves = this.getCompositeValue("javax.persistence.validation.group.pre-remove");
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("javax.persistence.lock.timeout")) {
            this.lockTimeoutChanged(newValue);
        } else if (propertyName.equals("javax.persistence.query.timeout")) {
            this.queryTimeoutChanged(newValue);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-persist")) {
            this.validationGroupPrePersistsChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-update")) {
            this.validationGroupPreUpdatesChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-remove")) {
            this.validationGroupPreRemovesChanged();
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("javax.persistence.lock.timeout")) {
            this.lockTimeoutChanged(null);
        } else if (propertyName.equals("javax.persistence.query.timeout")) {
            this.queryTimeoutChanged(null);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-persist")) {
            this.validationGroupPrePersistsChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-update")) {
            this.validationGroupPreUpdatesChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-remove")) {
            this.validationGroupPreRemovesChanged();
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("javax.persistence.lock.timeout", "lockTimeout");
        propertyNames.put("javax.persistence.query.timeout", "queryTimeout");
        propertyNames.put("javax.persistence.validation.group.pre-persist", "validationGroupPrePersist");
        propertyNames.put("javax.persistence.validation.group.pre-update", "validationGroupPreUpdate");
        propertyNames.put("javax.persistence.validation.group.pre-remove", "validationGroupPreRemove");
    }

    @Override
    public PersistenceUnit2_0 getPersistenceUnit() {
        return (PersistenceUnit2_0)super.getPersistenceUnit();
    }

    @Override
    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(Integer newLockTimeout) {
        Integer old = this.lockTimeout;
        this.lockTimeout = newLockTimeout;
        this.putProperty("lockTimeout", newLockTimeout);
        this.firePropertyChanged("lockTimeout", old, newLockTimeout);
    }

    private void lockTimeoutChanged(String stringValue) {
        Integer newValue = this.getIntegerValueOf(stringValue);
        Integer old = this.lockTimeout;
        this.lockTimeout = newValue;
        this.firePropertyChanged("lockTimeout", old, newValue);
    }

    @Override
    public Integer getDefaultLockTimeout() {
        return DEFAULT_LOCK_TIMEOUT;
    }

    @Override
    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(Integer newQueryTimeout) {
        Integer old = this.queryTimeout;
        this.queryTimeout = newQueryTimeout;
        this.putProperty("queryTimeout", newQueryTimeout);
        this.firePropertyChanged("queryTimeout", old, newQueryTimeout);
    }

    private void queryTimeoutChanged(String stringValue) {
        Integer newValue = this.getIntegerValueOf(stringValue);
        Integer old = this.queryTimeout;
        this.queryTimeout = newValue;
        this.firePropertyChanged("queryTimeout", old, newValue);
    }

    @Override
    public Integer getDefaultQueryTimeout() {
        return DEFAULT_QUERY_TIMEOUT;
    }

    @Override
    public ListIterable<String> getValidationGroupPrePersists() {
        return new LiveCloneListIterable(this.validationGroupPrePersists);
    }

    @Override
    public int getValidationGroupPrePersistsSize() {
        return this.validationGroupPrePersists.size();
    }

    @Override
    public boolean validationGroupPrePersistExists(String validationGroupPrePersistClassName) {
        for (String validationGroupPrePersist : this.validationGroupPrePersists) {
            if (!validationGroupPrePersist.equals(validationGroupPrePersistClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String addValidationGroupPrePersist(String newPrePersistClassName) {
        if (!this.validationGroupPrePersistExists(newPrePersistClassName)) {
            this.validationGroupPrePersists.add(newPrePersistClassName);
            this.putPropertyCompositeValue("validationGroupPrePersist", newPrePersistClassName);
            this.fireListChanged("validationGroupPrePersists", this.validationGroupPrePersists);
            return newPrePersistClassName;
        }
        return null;
    }

    @Override
    public void removeValidationGroupPrePersist(String className) {
        if (this.removeValidationGroupPrePersist_(className) != null) {
            this.removePropertyCompositeValue("validationGroupPrePersist", className);
            this.fireListChanged("validationGroupPrePersists", this.validationGroupPrePersists);
        }
    }

    private String removeValidationGroupPrePersist_(String className) {
        for (String validationGroupPrePersist : this.getValidationGroupPrePersists()) {
            if (!validationGroupPrePersist.equals(className)) continue;
            this.validationGroupPrePersists.remove(validationGroupPrePersist);
            return validationGroupPrePersist;
        }
        return null;
    }

    private void validationGroupPrePersistsChanged() {
        this.validationGroupPrePersists = this.getCompositeValue("javax.persistence.validation.group.pre-persist");
        this.fireListChanged("validationGroupPrePersists", this.validationGroupPrePersists);
    }

    @Override
    public ListIterable<String> getValidationGroupPreUpdates() {
        return new LiveCloneListIterable(this.validationGroupPreUpdates);
    }

    @Override
    public int getValidationGroupPreUpdatesSize() {
        return this.validationGroupPreUpdates.size();
    }

    @Override
    public boolean validationGroupPreUpdateExists(String validationGroupPreUpdateClassName) {
        for (String validationGroupPreUpdate : this.validationGroupPreUpdates) {
            if (!validationGroupPreUpdate.equals(validationGroupPreUpdateClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String addValidationGroupPreUpdate(String newPreUpdateClassName) {
        if (!this.validationGroupPreUpdateExists(newPreUpdateClassName)) {
            this.validationGroupPreUpdates.add(newPreUpdateClassName);
            this.putPropertyCompositeValue("validationGroupPreUpdate", newPreUpdateClassName);
            this.fireListChanged("validationGroupPreUpdates", this.validationGroupPreUpdates);
            return newPreUpdateClassName;
        }
        return null;
    }

    @Override
    public void removeValidationGroupPreUpdate(String className) {
        if (this.removeValidationGroupPreUpdate_(className) != null) {
            this.removePropertyCompositeValue("validationGroupPreUpdate", className);
            this.fireListChanged("validationGroupPreUpdates", this.validationGroupPreUpdates);
        }
    }

    private String removeValidationGroupPreUpdate_(String className) {
        for (String validationGroupPreUpdate : this.getValidationGroupPreUpdates()) {
            if (!validationGroupPreUpdate.equals(className)) continue;
            this.validationGroupPreUpdates.remove(validationGroupPreUpdate);
            return validationGroupPreUpdate;
        }
        return null;
    }

    private void validationGroupPreUpdatesChanged() {
        this.validationGroupPreUpdates = this.getCompositeValue("javax.persistence.validation.group.pre-update");
        this.fireListChanged("validationGroupPreUpdates", this.validationGroupPreUpdates);
    }

    @Override
    public ListIterable<String> getValidationGroupPreRemoves() {
        return new LiveCloneListIterable(this.validationGroupPreRemoves);
    }

    @Override
    public int getValidationGroupPreRemovesSize() {
        return this.validationGroupPreRemoves.size();
    }

    @Override
    public boolean validationGroupPreRemoveExists(String validationGroupPreRemoveClassName) {
        for (String validationGroupPreRemove : this.validationGroupPreRemoves) {
            if (!validationGroupPreRemove.equals(validationGroupPreRemoveClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String addValidationGroupPreRemove(String newPreRemoveClassName) {
        if (!this.validationGroupPreRemoveExists(newPreRemoveClassName)) {
            this.validationGroupPreRemoves.add(newPreRemoveClassName);
            this.putPropertyCompositeValue("validationGroupPreRemove", newPreRemoveClassName);
            this.fireListChanged("validationGroupPreRemoves", this.validationGroupPreRemoves);
            return newPreRemoveClassName;
        }
        return null;
    }

    @Override
    public void removeValidationGroupPreRemove(String className) {
        if (this.removeValidationGroupPreRemove_(className) != null) {
            this.removePropertyCompositeValue("validationGroupPreRemove", className);
            this.fireListChanged("validationGroupPreRemoves", this.validationGroupPreRemoves);
        }
    }

    private String removeValidationGroupPreRemove_(String className) {
        for (String validationGroupPreRemove : this.getValidationGroupPreRemoves()) {
            if (!validationGroupPreRemove.equals(className)) continue;
            this.validationGroupPreRemoves.remove(validationGroupPreRemove);
            return validationGroupPreRemove;
        }
        return null;
    }

    private void validationGroupPreRemovesChanged() {
        this.validationGroupPreRemoves = this.getCompositeValue("javax.persistence.validation.group.pre-remove");
        this.fireListChanged("validationGroupPreRemoves", this.validationGroupPreRemoves);
    }
}

