/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpa2;

import java.io.Serializable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.GeneratedAnnotation;

public interface MetamodelSynchronizer {
    public static final String METAMODEL_GENERATED_ANNOTATION_VALUE = "Dali";

    public void initializeMetamodel();

    public IStatus synchronizeMetamodel(IProgressMonitor var1);

    public void disposeMetamodel();

    public static final class MetamodelTools {
        public static boolean isGeneratedMetamodelTopLevelType(JavaResourceAbstractType jrat, IPackageFragmentRoot sourceFolder) {
            if (!jrat.isIn(sourceFolder)) {
                return false;
            }
            return MetamodelTools.isGeneratedMetamodelTopLevelType(jrat);
        }

        public static boolean isGeneratedMetamodelTopLevelType(JavaResourceAbstractType jrat) {
            if (!MetamodelTools.isGenerated(jrat)) {
                return false;
            }
            return MetamodelTools.isMetamodel(jrat);
        }

        public static boolean isGenerated(JavaResourceAbstractType jrat) {
            GeneratedAnnotation generatedAnnotation = (GeneratedAnnotation)jrat.getAnnotation("javax.annotation.Generated");
            if (generatedAnnotation == null) {
                return false;
            }
            if (generatedAnnotation.getValuesSize() != 1) {
                return false;
            }
            if (!generatedAnnotation.getValue(0).equals(MetamodelSynchronizer.METAMODEL_GENERATED_ANNOTATION_VALUE)) {
                return false;
            }
            return !StringTools.stringIsEmpty((String)generatedAnnotation.getDate());
        }

        public static boolean isMetamodel(JavaResourceAbstractType jrat) {
            for (JavaResourceAbstractType type : jrat.getAllTypes()) {
                if (type.getAnnotation("javax.persistence.metamodel.StaticMetamodel") == null) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Null
    implements MetamodelSynchronizer,
    Serializable {
        public static final MetamodelSynchronizer INSTANCE = new Null();
        private static final long serialVersionUID = 1L;

        public static MetamodelSynchronizer instance() {
            return INSTANCE;
        }

        private Null() {
        }

        public void initializeMetamodel() {
        }

        public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
            return Status.OK_STATUS;
        }

        public void disposeMetamodel() {
        }

        public String toString() {
            return StringTools.buildSingletonToString((Object)this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

