/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.prefs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.internal.prefs.JpaPreferencesManager;

public class JpaJpqlPreferencesManager
extends JpaPreferencesManager {
    private static final String JPQL_IDENTIFIER_PREFIX = "jpqlIdentifier.";
    public static final String JPQL_IDENTIFIER_LOWERCASE_PREF_VALUE = "lowercase";
    public static final String JPQL_IDENTIFIER_UPPERCASE_PREF_VALUE = "uppercase";
    public static final String CASE = "CASE";
    public static final String DEFAULT_CASE = "lowercase";
    public static final String MATCH_FIRST_CHARACTER_CASE = "MATCH_FIRST_CHARACTER_CASE";
    public static final boolean DEFAULT_MATCH_FIRST_CHARACTER_CASE = true;

    public static String getIdentifiersCaseWorkspacePreference() {
        return JpaJpqlPreferencesManager.getLegacyWorkspacePreference(JpaJpqlPreferencesManager.appendPrefix(CASE), JpaJpqlPreferencesManager.getDefaultIdentifiersCase());
    }

    public static void setIdentifiersCaseWorkspacePreference(String value) {
        if (StringTools.stringsAreEqual((String)value, (String)JpaJpqlPreferencesManager.getDefaultIdentifiersCase())) {
            JpaJpqlPreferencesManager.removeLegacyWorkspacePreference(JpaJpqlPreferencesManager.appendPrefix(CASE));
        } else {
            JpaJpqlPreferencesManager.setLegacyWorkspacePreference(JpaJpqlPreferencesManager.appendPrefix(CASE), value);
        }
    }

    public static String getDefaultIdentifiersCase() {
        return "lowercase";
    }

    public static boolean getMatchFirstCharacterCaseWorkspacePreference() {
        return JpaJpqlPreferencesManager.getLegacyWorkspacePreference(JpaJpqlPreferencesManager.appendPrefix(MATCH_FIRST_CHARACTER_CASE), JpaJpqlPreferencesManager.getDefaultMatchFirstCharacterCase());
    }

    public static void setMatchFirstCharacterCaseWorkspacePreference(boolean value) {
        if (value == JpaJpqlPreferencesManager.getDefaultMatchFirstCharacterCase()) {
            JpaJpqlPreferencesManager.removeLegacyWorkspacePreference(JpaJpqlPreferencesManager.appendPrefix(MATCH_FIRST_CHARACTER_CASE));
        } else {
            JpaJpqlPreferencesManager.setLegacyWorkspacePreference(JpaJpqlPreferencesManager.appendPrefix(MATCH_FIRST_CHARACTER_CASE), value);
        }
    }

    public static boolean getDefaultMatchFirstCharacterCase() {
        return true;
    }

    private static String appendPrefix(String prefId) {
        return JPQL_IDENTIFIER_PREFIX + prefId;
    }

    public JpaJpqlPreferencesManager(IProject project) {
        super(project);
    }
}

