/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import java.util.ArrayList;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.common.core.internal.resource.ResourceLocatorConfig;
import org.eclipse.jpt.common.core.internal.utility.XPointTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.KeyedSet;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;

public class ResourceLocatorManager {
    public static final String EXTENSION_POINT_ID = "resourceLocators";
    public static final String QUALIFIED_EXTENSION_POINT_ID = "org.eclipse.jpt.common.core.resourceLocators";
    public static final String RESOURCE_LOCATOR_ELEMENT = "resourceLocator";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String PRIORITY_ATTRIBUTE = "priority";
    public static final String ENABLEMENT_ELEMENT = "enablement";
    private static ResourceLocatorManager INSTANCE = new ResourceLocatorManager();
    private KeyedSet<String, ResourceLocatorConfig> resourceLocatorConfigs = new KeyedSet();

    public static ResourceLocatorManager instance() {
        return INSTANCE;
    }

    private ResourceLocatorManager() {
        this.readExtensions();
    }

    public ResourceLocator getResourceLocator(final IProject project) {
        Iterable sortedConfigs = CollectionTools.sort((Iterable)new FilteringIterable<ResourceLocatorConfig>((Iterable)this.resourceLocatorConfigs.getItemSet()){

            protected boolean accept(ResourceLocatorConfig o) {
                return o.isEnabledFor(project) && o.getResourceLocator() != null;
            }
        });
        for (ResourceLocatorConfig config : sortedConfigs) {
            ResourceLocator locator = config.getResourceLocator();
            if (locator == null) continue;
            return locator;
        }
        return null;
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xpoint = registry.getExtensionPoint(QUALIFIED_EXTENSION_POINT_ID);
        if (xpoint == null) {
            throw new IllegalStateException();
        }
        ArrayList<IConfigurationElement> configs = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = xpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                configs.add(element);
                ++n4;
            }
            ++n2;
        }
        for (IConfigurationElement element : configs) {
            if (!element.getName().equals(RESOURCE_LOCATOR_ELEMENT)) continue;
            this.readExtension(element);
        }
    }

    private void readExtension(IConfigurationElement element) {
        try {
            ResourceLocatorConfig rlConfig = new ResourceLocatorConfig();
            rlConfig.setPluginId(element.getContributor().getName());
            rlConfig.setId(XPointTools.findRequiredAttribute(element, ID_ATTRIBUTE));
            if (this.resourceLocatorConfigs.containsKey((Object)rlConfig.getId())) {
                XPointTools.logDuplicateExtension(QUALIFIED_EXTENSION_POINT_ID, ID_ATTRIBUTE, rlConfig.getId());
                throw new XPointTools.XPointException();
            }
            rlConfig.setClassName(XPointTools.findRequiredAttribute(element, CLASS_ATTRIBUTE));
            String priorityString = element.getAttribute(PRIORITY_ATTRIBUTE).trim();
            ResourceLocatorConfig.Priority priority = ResourceLocatorConfig.Priority.get(priorityString);
            if (priority == null) {
                XPointTools.logInvalidValue(element, PRIORITY_ATTRIBUTE, priorityString);
                throw new XPointTools.XPointException();
            }
            rlConfig.setPriority(priority);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String childName = child.getName();
                if (childName.equals(ENABLEMENT_ELEMENT)) {
                    Expression expr;
                    try {
                        expr = ExpressionConverter.getDefault().perform(child);
                    }
                    catch (CoreException e) {
                        XPointTools.log(e);
                        throw new XPointTools.XPointException();
                    }
                    rlConfig.setEnablementCondition(expr);
                }
                ++n2;
            }
            this.resourceLocatorConfigs.addItem((Object)rlConfig.getId(), (Object)rlConfig);
        }
        catch (XPointTools.XPointException xPointException) {}
    }
}

