/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;

final class BinaryField
extends BinaryAttribute
implements JavaResourceField {
    BinaryField(JavaResourceType parent, IField field) {
        super(parent, new FieldAdapter(field));
    }

    public JavaResourceAnnotatedElement.Kind getKind() {
        return JavaResourceAnnotatedElement.Kind.FIELD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldAdapter
    implements BinaryAttribute.Adapter {
        final IField field;

        FieldAdapter(IField field) {
            this.field = field;
        }

        public IField getElement() {
            return this.field;
        }

        @Override
        public Iterable<ITypeParameter> getTypeParameters() {
            try {
                return new ArrayIterable((Object[])this.field.getDeclaringType().getTypeParameters());
            }
            catch (JavaModelException jme) {
                JptCommonCorePlugin.log(jme);
                return EmptyIterable.instance();
            }
        }

        @Override
        public IAnnotation[] getAnnotations() throws JavaModelException {
            return this.field.getAnnotations();
        }

        @Override
        public String getAttributeName() {
            return this.field.getElementName();
        }

        @Override
        public String getTypeSignature() throws JavaModelException {
            return this.field.getTypeSignature();
        }
    }
}

