/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.HashMap;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.jdt.AbstractType;
import org.eclipse.jpt.common.utility.internal.SimpleIntReference;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAbstractType<A extends AbstractType>
extends SourceMember<A>
implements JavaResourceAbstractType {
    private String name;
    private String qualifiedName;
    private String packageName;
    private String declaringTypeName;
    private boolean memberType;

    protected SourceAbstractType(JavaResourceCompilationUnit javaResourceCompilationUnit, A type) {
        super((JavaResourceNode)javaResourceCompilationUnit, type);
    }

    @Override
    protected void initialize(IBinding binding) {
        super.initialize(binding);
        this.name = this.buildName((ITypeBinding)binding);
        this.qualifiedName = this.buildQualifiedName((ITypeBinding)binding);
        this.packageName = this.buildPackageName((ITypeBinding)binding);
        this.declaringTypeName = this.buildDeclaringTypeName((ITypeBinding)binding);
        this.memberType = this.buildMemberType((ITypeBinding)binding);
    }

    @Override
    protected void synchronizeWith(IBinding binding) {
        super.synchronizeWith(binding);
        this.syncName(this.buildName((ITypeBinding)binding));
        this.syncQualifiedName(this.buildQualifiedName((ITypeBinding)binding));
        this.syncPackageName(this.buildPackageName((ITypeBinding)binding));
        this.syncDeclaringTypeName(this.buildDeclaringTypeName((ITypeBinding)binding));
        this.syncMemberType(this.buildMemberType((ITypeBinding)binding));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(ITypeBinding binding) {
        return binding == null ? null : binding.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void syncQualifiedName(String astQualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = astQualifiedName;
        this.firePropertyChanged("qualifiedName", old, astQualifiedName);
    }

    private String buildQualifiedName(ITypeBinding binding) {
        return binding == null ? null : binding.getQualifiedName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private void syncPackageName(String astPackageName) {
        String old = this.packageName;
        this.packageName = astPackageName;
        this.firePropertyChanged("packageName", old, astPackageName);
    }

    private String buildPackageName(ITypeBinding binding) {
        return binding == null ? null : binding.getPackage().getName();
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return StringTools.stringsAreEqual((String)packageFragment.getElementName(), (String)this.packageName);
    }

    @Override
    public boolean isIn(IPackageFragmentRoot sourceFolder) {
        return this.getSourceFolder().equals(sourceFolder);
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getJavaResourceCompilationUnit().getCompilationUnit().getAncestor(3);
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void syncDeclaringTypeName(String astDeclaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = astDeclaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, astDeclaringTypeName);
    }

    private String buildDeclaringTypeName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        return declaringClass == null ? null : declaringClass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isMemberType() {
        return this.memberType;
    }

    private void syncMemberType(boolean astMemberType) {
        boolean old = this.memberType;
        this.memberType = astMemberType;
        this.firePropertyChanged("memberType", old, astMemberType);
    }

    private boolean buildMemberType(ITypeBinding binding) {
        return binding == null ? false : binding.isMember();
    }

    protected static class CounterMap {
        private final HashMap<Object, SimpleIntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            SimpleIntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new SimpleIntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }
}

