/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAttribute<A extends Attribute>
extends SourceMember<A>
implements JavaResourceAttribute {
    private int modifiers;
    private String typeName;
    private boolean typeIsInterface;
    private boolean typeIsEnum;
    private boolean typeIsArray;
    private int typeArrayDimensionality;
    private String typeArrayComponentTypeName;
    private final Vector<String> typeSuperclassNames = new Vector();
    private final Vector<String> typeInterfaceNames = new Vector();
    private final Vector<String> typeTypeArgumentNames = new Vector();

    protected SourceAttribute(JavaResourceType parent, A attribute) {
        super((JavaResourceNode)parent, attribute);
    }

    @Override
    protected void initialize(IBinding binding) {
        super.initialize(binding);
        this.modifiers = this.buildModifiers(binding);
    }

    protected void initialize(ITypeBinding attributeTypeBinding) {
        this.typeName = this.buildTypeName(attributeTypeBinding);
        this.typeIsInterface = this.buildTypeIsInterface(attributeTypeBinding);
        this.typeIsEnum = this.buildTypeIsEnum(attributeTypeBinding);
        this.typeIsArray = this.buildTypeIsArray(attributeTypeBinding);
        this.typeArrayDimensionality = this.buildTypeArrayDimensionality(attributeTypeBinding);
        this.typeArrayComponentTypeName = this.buildTypeArrayComponentTypeName(attributeTypeBinding);
        this.typeSuperclassNames.addAll(this.buildTypeSuperclassNames(attributeTypeBinding));
        this.typeInterfaceNames.addAll(this.buildTypeInterfaceNames(attributeTypeBinding));
        this.typeTypeArgumentNames.addAll(this.buildTypeTypeArgumentNames(attributeTypeBinding));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.resolveTypes(this.getTypeBinding(astRoot));
    }

    protected void resolveTypes(ITypeBinding typeBinding) {
        this.syncTypeName(this.buildTypeName(typeBinding));
        this.syncTypeArrayComponentTypeName(this.buildTypeArrayComponentTypeName(typeBinding));
        this.syncTypeSuperclassNames(this.buildTypeSuperclassNames(typeBinding));
        this.syncTypeInterfaceNames(this.buildTypeInterfaceNames(typeBinding));
        this.syncTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(typeBinding));
    }

    protected void synchronizeWith(ITypeBinding attributeTypeBinding) {
        this.syncTypeName(this.buildTypeName(attributeTypeBinding));
        this.syncTypeIsInterface(this.buildTypeIsInterface(attributeTypeBinding));
        this.syncTypeIsEnum(this.buildTypeIsEnum(attributeTypeBinding));
        this.syncTypeIsArray(this.buildTypeIsArray(attributeTypeBinding));
        this.syncTypeArrayDimensionality(this.buildTypeArrayDimensionality(attributeTypeBinding));
        this.syncTypeArrayComponentTypeName(this.buildTypeArrayComponentTypeName(attributeTypeBinding));
        this.syncTypeSuperclassNames(this.buildTypeSuperclassNames(attributeTypeBinding));
        this.syncTypeInterfaceNames(this.buildTypeInterfaceNames(attributeTypeBinding));
        this.syncTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(attributeTypeBinding));
    }

    @Override
    protected void synchronizeWith(IBinding binding) {
        super.synchronizeWith(binding);
        this.syncModifiers(this.buildModifiers(binding));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public JavaResourceType getParent() {
        return (JavaResourceType)super.getParent();
    }

    @Override
    public JavaResourceType getResourceType() {
        return this.getParent();
    }

    @Override
    public String getName() {
        return ((Attribute)this.annotatedElement).getAttributeName();
    }

    @Override
    public boolean typeIsSubTypeOf(String tn) {
        if (this.typeName == null) {
            return false;
        }
        return this.typeName.equals(tn) || this.typeInterfaceNames.contains(tn) || this.typeSuperclassNames.contains(tn);
    }

    @Override
    public boolean typeIsVariablePrimitive() {
        return this.typeName != null && ClassName.isVariablePrimitive((String)this.typeName);
    }

    protected ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        return ((Attribute)this.annotatedElement).getTypeBinding(astRoot);
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void syncModifiers(int astModifiers) {
        int old = this.modifiers;
        this.modifiers = astModifiers;
        this.firePropertyChanged("modifiers", old, astModifiers);
    }

    private int buildModifiers(IBinding binding) {
        return binding == null ? 0 : binding.getModifiers();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    private void syncTypeName(String astTypeName) {
        String old = this.typeName;
        this.typeName = astTypeName;
        this.firePropertyChanged("typeName", old, astTypeName);
    }

    private String buildTypeName(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return null;
        }
        String tbName = (typeBinding = typeBinding.getErasure()).getTypeDeclaration().getQualifiedName();
        return tbName.length() == 0 ? null : tbName;
    }

    @Override
    public boolean typeIsInterface() {
        return this.typeIsInterface;
    }

    private void syncTypeIsInterface(boolean astTypeIsInterface) {
        boolean old = this.typeIsInterface;
        this.typeIsInterface = astTypeIsInterface;
        this.firePropertyChanged("typeIsInterface", old, astTypeIsInterface);
    }

    private boolean buildTypeIsInterface(ITypeBinding typeBinding) {
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isInterface();
    }

    @Override
    public boolean typeIsEnum() {
        return this.typeIsEnum;
    }

    private void syncTypeIsEnum(boolean astTypeIsEnum) {
        boolean old = this.typeIsEnum;
        this.typeIsEnum = astTypeIsEnum;
        this.firePropertyChanged("typeIsEnum", old, astTypeIsEnum);
    }

    private boolean buildTypeIsEnum(ITypeBinding typeBinding) {
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isEnum();
    }

    @Override
    public boolean typeIsArray() {
        return this.typeIsArray;
    }

    private void syncTypeIsArray(boolean astTypeIsArray) {
        boolean old = this.typeIsArray;
        this.typeIsArray = astTypeIsArray;
        this.firePropertyChanged("typeIsArray", old, astTypeIsArray);
    }

    private boolean buildTypeIsArray(ITypeBinding typeBinding) {
        return typeBinding != null && typeBinding.isArray();
    }

    @Override
    public int getTypeArrayDimensionality() {
        return this.typeArrayDimensionality;
    }

    private void syncTypeArrayDimensionality(int astTypeArrayDimensionality) {
        int old = this.typeArrayDimensionality;
        this.typeArrayDimensionality = astTypeArrayDimensionality;
        this.firePropertyChanged("typeArrayDimensionality", old, astTypeArrayDimensionality);
    }

    private int buildTypeArrayDimensionality(ITypeBinding typeBinding) {
        return typeBinding == null ? 0 : typeBinding.getDimensions();
    }

    @Override
    public String getTypeArrayComponentTypeName() {
        return this.typeArrayComponentTypeName;
    }

    private void syncTypeArrayComponentTypeName(String astTypeArrayComponentTypeName) {
        String old = this.typeArrayComponentTypeName;
        this.typeArrayComponentTypeName = astTypeArrayComponentTypeName;
        this.firePropertyChanged("typeArrayComponentTypeName", old, astTypeArrayComponentTypeName);
    }

    /*
     * Unable to fully structure code
     */
    private String buildTypeArrayComponentTypeName(ITypeBinding typeBinding) {
        if (typeBinding != null && typeBinding.isArray()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = typeBinding.getComponentType()) != null) continue;
            return null;
lbl5:
            // 2 sources

            ** while (typeBinding.isArray())
        }
lbl6:
        // 1 sources

        if (typeBinding.isTypeVariable()) {
            typeBinding = typeBinding.getErasure();
        }
        return (tbName = typeBinding.getTypeDeclaration().getQualifiedName()).length() == 0 ? null : tbName;
    }

    @Override
    public ListIterable<String> getTypeSuperclassNames() {
        return new LiveCloneListIterable(this.typeSuperclassNames);
    }

    private void syncTypeSuperclassNames(List<String> astTypeSuperclassNames) {
        this.synchronizeList(astTypeSuperclassNames, this.typeSuperclassNames, "typeSuperclassNames");
    }

    private List<String> buildTypeSuperclassNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        typeBinding = typeBinding.getSuperclass();
        while (typeBinding != null) {
            names.add(typeBinding.getErasure().getQualifiedName());
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    @Override
    public Iterable<String> getTypeInterfaceNames() {
        return new LiveCloneIterable(this.typeInterfaceNames);
    }

    private void syncTypeInterfaceNames(Collection<String> astTypeInterfaceNames) {
        this.synchronizeCollection(astTypeInterfaceNames, this.typeInterfaceNames, "typeInterfaceNames");
    }

    private Collection<String> buildTypeInterfaceNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        while (typeBinding != null) {
            this.addInterfaceNamesTo(typeBinding, names);
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    private void addInterfaceNamesTo(ITypeBinding typeBinding, HashSet<String> names) {
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            names.add(interfaceBinding.getTypeDeclaration().getErasure().getQualifiedName());
            this.addInterfaceNamesTo(interfaceBinding, names);
            ++n2;
        }
    }

    @Override
    public ListIterable<String> getTypeTypeArgumentNames() {
        return new LiveCloneListIterable(this.typeTypeArgumentNames);
    }

    @Override
    public int getTypeTypeArgumentNamesSize() {
        return this.typeTypeArgumentNames.size();
    }

    @Override
    public String getTypeTypeArgumentName(int index) {
        return this.typeTypeArgumentNames.get(index);
    }

    private void syncTypeTypeArgumentNames(List<String> astTypeTypeArgumentNames) {
        this.synchronizeList(astTypeTypeArgumentNames, this.typeTypeArgumentNames, "typeTypeArgumentNames");
    }

    private List<String> buildTypeTypeArgumentNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArguments.length);
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            if (typeArgument == null) {
                names.add(null);
            } else {
                ITypeBinding erasure = typeArgument.getErasure();
                names.add(erasure.getTypeDeclaration().getQualifiedName());
            }
            ++n2;
        }
        return names;
    }
}

