/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.ListenerList;

public abstract class SourceCompilationUnit
extends SourceNode
implements JavaResourceCompilationUnit {
    final ICompilationUnit compilationUnit;
    private final AnnotationProvider annotationProvider;
    private final AnnotationEditFormatter annotationEditFormatter;
    private final CommandExecutor modifySharedDocumentCommandExecutor;
    private final ListenerList<JptResourceModelListener> resourceModelListenerList;

    protected SourceCompilationUnit(ICompilationUnit compilationUnit, AnnotationProvider annotationProvider, AnnotationEditFormatter annotationEditFormatter, CommandExecutor modifySharedDocumentCommandExecutor) {
        super(null);
        this.compilationUnit = compilationUnit;
        this.annotationProvider = annotationProvider;
        this.annotationEditFormatter = annotationEditFormatter;
        this.modifySharedDocumentCommandExecutor = modifySharedDocumentCommandExecutor;
        this.resourceModelListenerList = new ListenerList(JptResourceModelListener.class);
    }

    public void initialize(CompilationUnit astRoot) {
    }

    void openCompilationUnit() {
        try {
            this.compilationUnit.open(null);
        }
        catch (JavaModelException javaModelException) {}
    }

    void closeCompilationUnit() {
        try {
            this.compilationUnit.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    protected boolean requiresParent() {
        return false;
    }

    public JavaResourceCompilationUnit getRoot() {
        return this;
    }

    public IFile getFile() {
        return (IFile)this.compilationUnit.getResource();
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public TextRange getTextRange(CompilationUnit astRoot) {
        return null;
    }

    public void resourceModelChanged() {
        for (JptResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelChanged(this);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public CommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutor;
    }

    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return this.annotationEditFormatter;
    }

    public CompilationUnit buildASTRoot() {
        return ASTTools.buildASTRoot(this.compilationUnit);
    }

    public void addResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.add((Object)listener);
    }

    public void removeResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.remove((Object)listener);
    }

    public void synchronizeWithJavaSource() {
        this.synchronizeWith(this.buildASTRoot());
    }

    String getCompilationUnitName() {
        return this.removeJavaExtension(this.compilationUnit.getElementName());
    }

    private String removeJavaExtension(String fileName) {
        int index = fileName.lastIndexOf(".java");
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getCompilationUnitName());
    }
}

