/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.FileTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.internal.gen.SchemaGenerator;
import org.eclipse.jpt.jaxb.core.internal.operations.SchemaFileCreationDataModelProvider;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.NewSchemaFileWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.SchemaGeneratorWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGeneratorWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection initialSelection;
    private IJavaProject targetProject;
    protected IDataModel dataModel;
    private NewSchemaFileWizardPage newSchemaFileWizardPage;
    private SchemaGeneratorWizardPage schemaGenWizardPage;
    public static final String XSD_EXTENSION = ".xsd";

    public SchemaGeneratorWizard() {
        this.setWindowTitle(JptJaxbUiMessages.SchemaGeneratorWizard_title);
        this.setDefaultPageImageDescriptor(JptJaxbUiPlugin.getImageDescriptor("full/wizban/NewXSD"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        this.targetProject = this.getProjectFromInitialSelection();
        this.dataModel = null;
    }

    public void addPages() {
        super.addPages();
        this.newSchemaFileWizardPage = this.buildNewSchemaFileWizardPage(this.initialSelection);
        this.addPage((IWizardPage)this.newSchemaFileWizardPage);
        this.schemaGenWizardPage = this.buildSchemaGeneratorWizardPage(this.buildSelection(this.getProject()));
        this.addPage((IWizardPage)this.schemaGenWizardPage);
    }

    public boolean performFinish() {
        this.targetProject = this.getJavaProject();
        String[] sourceClassNames = this.buildSourceClassNames(this.getAllCheckedItems());
        this.scheduleGenerateSchemaJob(sourceClassNames);
        return true;
    }

    protected void scheduleGenerateSchemaJob(String[] sourceClassNames) {
        GenerateSchemaJob genSchemaJob = new GenerateSchemaJob(this.targetProject, sourceClassNames, this.getTargetSchema(), this.usesMoxy());
        genSchemaJob.schedule();
    }

    public IJavaProject getJavaProject() {
        return this.getJavaProjectFrom(this.getProject());
    }

    private IProject getProject() {
        return this.newSchemaFileWizardPage.getProject();
    }

    private IJavaProject getProjectFromInitialSelection() {
        IJavaProject project = null;
        Object firstElement = this.initialSelection.getFirstElement();
        if (firstElement instanceof IJavaElement) {
            IJavaElement javaElement = (IJavaElement)firstElement;
            int type = javaElement.getElementType();
            if (type == 2) {
                project = (IJavaProject)javaElement;
            } else if (type == 4) {
                project = ((IPackageFragment)javaElement).getJavaProject();
            }
        }
        return project;
    }

    private IJavaProject getJavaProjectFrom(IProject project) {
        IJavaProject javaProject = ((IJavaElement)project.getAdapter(IJavaElement.class)).getJavaProject();
        if (javaProject == null) {
            throw new RuntimeException("Not a Java Project");
        }
        return javaProject;
    }

    private String getTargetSchema() {
        IPath filePath = this.newSchemaFileWizardPage.getFileRelativePath();
        String fileName = this.newSchemaFileWizardPage.getFileName();
        String targetSchema = filePath.isEmpty() ? fileName : String.valueOf(filePath.toOSString()) + File.separator + fileName;
        return this.addXsdExtension(targetSchema);
    }

    private String addXsdExtension(String fileName) {
        return FileTools.extension((String)fileName).equalsIgnoreCase(XSD_EXTENSION) ? fileName : String.valueOf(fileName) + XSD_EXTENSION;
    }

    private Object[] getAllCheckedItems() {
        return this.schemaGenWizardPage.getAllCheckedItems();
    }

    private String[] buildSourceClassNames(Object[] checkedElements) {
        ArrayList<String> classNames = new ArrayList<String>();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IJavaElement javaElement = (IJavaElement)element;
            String packageName = javaElement.getParent().getElementName();
            String elementName = javaElement.getElementName();
            String className = FileTools.stripExtension((String)elementName);
            if (StringTools.stringIsEmpty((String)packageName)) {
                classNames.add(className);
            } else {
                classNames.add(String.valueOf(packageName) + '.' + className);
            }
            ++n2;
        }
        return (String[])ArrayTools.array(classNames, (Object[])new String[0]);
    }

    private boolean usesMoxy() {
        return this.schemaGenWizardPage.usesMoxy();
    }

    protected NewSchemaFileWizardPage buildNewSchemaFileWizardPage(IStructuredSelection selection) {
        return new NewSchemaFileWizardPage("Page_1", selection, this.getDataModel(), JptJaxbUiMessages.SchemaGeneratorProjectWizardPage_title, JptJaxbUiMessages.SchemaGeneratorProjectWizardPage_desc);
    }

    protected SchemaGeneratorWizardPage buildSchemaGeneratorWizardPage(IStructuredSelection selection) {
        return new SchemaGeneratorWizardPage(selection);
    }

    private IStructuredSelection buildSelection(IProject project) {
        ArrayList<IAdaptable> selectedElements = new ArrayList<IAdaptable>(1);
        this.addProjectTo(selectedElements, project);
        return new StructuredSelection(selectedElements);
    }

    private void addProjectTo(List<IAdaptable> selectedElements, IProject project) {
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                selectedElements.add((IAdaptable)JavaCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {}
    }

    protected IDataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = DataModelFactory.createDataModel((IDataModelProvider)this.getDefaultProvider());
        }
        return this.dataModel;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new SchemaFileCreationDataModelProvider();
    }

    static class GenerateSchemaJob
    extends WorkspaceJob {
        private final IJavaProject javaProject;
        private final String[] sourceClassNames;
        private final String targetSchema;
        private final boolean useMoxy;

        GenerateSchemaJob(IJavaProject project, String[] sourceClassNames, String targetSchema, boolean useMoxy) {
            super(JptJaxbUiMessages.SchemaGeneratorWizard_generatingSchema);
            this.javaProject = project;
            this.sourceClassNames = sourceClassNames;
            this.targetSchema = targetSchema;
            this.useMoxy = useMoxy;
            this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)this.javaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)JptJaxbUiMessages.SchemaGeneratorWizard_generateSchemaTask, (Object)this.targetSchema), (int)1);
            try {
                SchemaGenerator.generate((IJavaProject)this.javaProject, (String)this.targetSchema, (String[])this.sourceClassNames, (boolean)this.useMoxy, (IProgressMonitor)sm.newChild(1));
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    public static class OpenSchemaFileJob
    extends WorkspaceJob {
        private final IJavaProject javaProject;
        private final IFile schemaFile;

        public OpenSchemaFileJob(IJavaProject javaProject, IFile schemaFile) {
            super(JptJaxbUiMessages.SchemaGeneratorWizard_openSchemaFileJobName);
            this.javaProject = javaProject;
            this.schemaFile = schemaFile;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)this.javaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                this.postGeneration(this.schemaFile);
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jaxb.ui", "error", (Throwable)e));
            }
            return Status.OK_STATUS;
        }

        private void postGeneration(IFile schemaFile) throws InvocationTargetException {
            try {
                this.openEditor(schemaFile);
            }
            catch (Exception cantOpen) {
                throw new InvocationTargetException(cantOpen);
            }
        }

        private void openEditor(final IFile file) {
            if (file != null) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                        catch (PartInitException e) {
                            JptJaxbUiPlugin.log(e);
                        }
                    }
                });
            }
        }
    }
}

