/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtilImpl;

public class AddInheritedEntityFeature
extends AbstractAddFeature {
    private IJPAEditorImageCreator imageCreator;

    public AddInheritedEntityFeature(IFeatureProvider fp) {
        this(fp, new JPAEditorImageCreator(), new JPAEditorUtilImpl());
    }

    public AddInheritedEntityFeature(IFeatureProvider fp, IJPAEditorImageCreator imageCreator, IJPAEditorUtil jpaEditorUtil) {
        super(fp);
        this.imageCreator = imageCreator;
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        IAddConnectionContext addConContext = (IAddConnectionContext)context;
        IsARelation relation = (IsARelation)context.getNewObject();
        Diagram diagram = this.getDiagram();
        FreeFormConnection connection = this.createIsAConnection(addConContext, relation, diagram);
        this.imageCreator.createIsAConnectionLine(diagram, (Connection)connection);
        this.layoutPictogramElement((PictogramElement)connection);
        return connection;
    }

    private FreeFormConnection createIsAConnection(IAddConnectionContext addConContext, IsARelation relation, Diagram diagram) {
        FreeFormConnection connection = this.getFeatureProvider().getPeService().createFreeFormConnection(diagram);
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        connection.setVisible(true);
        connection.setActive(true);
        this.getFeatureProvider().getPeServiceUtil().setPropertyValue((PropertyContainer)connection, "is_is_a_connection", Boolean.TRUE.toString());
        this.addDecorators(connection);
        return connection;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private void addDecorators(FreeFormConnection c) {
        ConnectionDecorator d = this.imageCreator.createArrowConnectionDecorator((Connection)c, 0.9999, true);
        Graphiti.getGaService().setLocation(d.getGraphicsAlgorithm(), 0, 0);
    }
}

