/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.listeners;

import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;

public class SWTCollectionChangeListenerWrapper
implements CollectionChangeListener {
    private final CollectionChangeListener listener;

    public SWTCollectionChangeListenerWrapper(CollectionChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(CollectionAddEvent event) {
        this.execute((Runnable)((Object)new ItemsAddedRunnable(event)));
    }

    void itemsAdded_(CollectionAddEvent event) {
        this.listener.itemsAdded(event);
    }

    public void itemsRemoved(CollectionRemoveEvent event) {
        this.execute((Runnable)((Object)new ItemsRemovedRunnable(event)));
    }

    void itemsRemoved_(CollectionRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    public void collectionCleared(CollectionClearEvent event) {
        this.execute((Runnable)((Object)new CollectionClearedRunnable(event)));
    }

    void collectionCleared_(CollectionClearEvent event) {
        this.listener.collectionCleared(event);
    }

    public void collectionChanged(CollectionChangeEvent event) {
        this.execute((Runnable)((Object)new CollectionChangedRunnable(event)));
    }

    void collectionChanged_(CollectionChangeEvent event) {
        this.listener.collectionChanged(event);
    }

    private void execute(Runnable r) {
        SWTUtil.execute(r);
    }

    public String toString() {
        return "SWT(" + this.listener + ')';
    }

    class CollectionChangedRunnable
    extends RunnableAdapter {
        private final CollectionChangeEvent event;

        CollectionChangedRunnable(CollectionChangeEvent event) {
            this.event = event;
        }

        public void run() {
            SWTCollectionChangeListenerWrapper.this.collectionChanged_(this.event);
        }
    }

    class CollectionClearedRunnable
    extends RunnableAdapter {
        private final CollectionClearEvent event;

        CollectionClearedRunnable(CollectionClearEvent event) {
            this.event = event;
        }

        public void run() {
            SWTCollectionChangeListenerWrapper.this.collectionCleared_(this.event);
        }
    }

    class ItemsAddedRunnable
    extends RunnableAdapter {
        private final CollectionAddEvent event;

        ItemsAddedRunnable(CollectionAddEvent event) {
            this.event = event;
        }

        public void run() {
            SWTCollectionChangeListenerWrapper.this.itemsAdded_(this.event);
        }
    }

    class ItemsRemovedRunnable
    extends RunnableAdapter {
        private final CollectionRemoveEvent event;

        ItemsRemovedRunnable(CollectionRemoveEvent event) {
            this.event = event;
        }

        public void run() {
            SWTCollectionChangeListenerWrapper.this.itemsRemoved_(this.event);
        }
    }
}

