/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.utility.swt;

import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.DisposeAdapter;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.RunnableAdapter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BooleanStateController {
    private final PropertyValueModel<Boolean> booleanModel;
    private final PropertyChangeListener booleanChangeListener;
    private final DisposeListener controlDisposeListener;
    private final boolean defaultValue;
    private final Adapter adapter;

    BooleanStateController(PropertyValueModel<Boolean> booleanModel, boolean defaultValue, Adapter adapter) {
        if (booleanModel == null || adapter == null) {
            throw new NullPointerException();
        }
        this.booleanModel = booleanModel;
        this.defaultValue = defaultValue;
        this.adapter = adapter;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.controlDisposeListener = this.buildControlDisposeListener();
    }

    private PropertyChangeListener buildBooleanChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildBooleanChangeListener_());
    }

    private PropertyChangeListener buildBooleanChangeListener_() {
        return new BooleanChangeListener();
    }

    private DisposeListener buildControlDisposeListener() {
        return new ControlDisposeListener();
    }

    void engageBooleanModel() {
        this.booleanModel.addPropertyChangeListener("value", this.booleanChangeListener);
    }

    void disengageBooleanModel() {
        this.booleanModel.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    void booleanChanged(PropertyChangeEvent event) {
        this.setControlState((Boolean)event.getNewValue());
    }

    boolean getBooleanValue() {
        return this.booleanValue((Boolean)this.booleanModel.getValue());
    }

    private boolean booleanValue(Boolean b) {
        return b != null ? b : this.defaultValue;
    }

    void engageControl(Control control) {
        control.addDisposeListener(this.controlDisposeListener);
    }

    void disengageControl(Control control) {
        control.removeDisposeListener(this.controlDisposeListener);
    }

    private void setControlState(Boolean controlState) {
        this.setControlState(this.booleanValue(controlState));
    }

    abstract void setControlState(boolean var1);

    void setControlState(Control control, boolean controlState) {
        SWTUtil.execute((Runnable)((Object)new SetControlStateRunnable(control, controlState)));
    }

    void setControlState_(Control control, boolean controlState) {
        if (!control.isDisposed()) {
            this.adapter.setState(control, controlState);
        }
    }

    void controlDisposed(Control control) {
        this.disengageControl(control);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.booleanModel);
    }

    static interface Adapter {
        public void setState(Control var1, boolean var2);
    }

    class BooleanChangeListener
    extends PropertyChangeAdapter {
        BooleanChangeListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            BooleanStateController.this.booleanChanged(event);
        }
    }

    class ControlDisposeListener
    extends DisposeAdapter {
        ControlDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            BooleanStateController.this.controlDisposed((Control)event.widget);
        }
    }

    class SetControlStateRunnable
    extends RunnableAdapter {
        private final Control control;
        private final boolean controlState;

        SetControlStateRunnable(Control control, boolean controlState) {
            this.control = control;
            this.controlState = controlState;
        }

        public void run() {
            BooleanStateController.this.setControlState_(this.control, this.controlState);
        }
    }
}

