/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.utility.swt;

import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.utility.swt.ListWidgetModelBinding;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DropDownListBoxSelectionBinding<E>
implements ListWidgetModelBinding.SelectionBinding {
    private final ListValueModel<E> listModel;
    private final ModifiablePropertyValueModel<E> selectedItemModel;
    private final PropertyChangeListener selectedItemChangeListener;
    private final DropDownListBox dropdownListBox;
    private final SelectionListener dropdownListBoxSelectionListener;

    DropDownListBoxSelectionBinding(ListValueModel<E> listModel, ModifiablePropertyValueModel<E> selectedItemModel, DropDownListBox dropdownListBox) {
        if (listModel == null || selectedItemModel == null || dropdownListBox == null) {
            throw new NullPointerException();
        }
        this.listModel = listModel;
        this.selectedItemModel = selectedItemModel;
        this.dropdownListBox = dropdownListBox;
        this.selectedItemChangeListener = this.buildSelectedItemChangeListener();
        this.selectedItemModel.addPropertyChangeListener("value", this.selectedItemChangeListener);
        this.dropdownListBoxSelectionListener = this.buildDropDownListBoxSelectionListener();
        this.dropdownListBox.addSelectionListener(this.dropdownListBoxSelectionListener);
    }

    private PropertyChangeListener buildSelectedItemChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSelectedItemChangeListener_());
    }

    private PropertyChangeListener buildSelectedItemChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                DropDownListBoxSelectionBinding.this.selectedItemChanged(event);
            }

            public String toString() {
                return "selected item listener";
            }
        };
    }

    private SelectionListener buildDropDownListBoxSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DropDownListBoxSelectionBinding.this.dropDownListBoxSelectionChanged(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                DropDownListBoxSelectionBinding.this.dropDownListBoxDoubleClicked(event);
            }

            public String toString() {
                return "drop-down list box selection listener";
            }
        };
    }

    @Override
    public void synchronizeListWidgetSelection() {
        int oldIndex = this.dropdownListBox.getSelectionIndex();
        Object value = this.selectedItemModel.getValue();
        int newIndex = this.indexOf(value);
        if (oldIndex != -1 && newIndex != -1 && newIndex != oldIndex) {
            this.dropdownListBox.deselect(oldIndex);
        }
        if (newIndex == -1) {
            this.dropdownListBox.deselectAll();
        } else if (newIndex != oldIndex) {
            this.dropdownListBox.select(newIndex);
        }
    }

    @Override
    public void dispose() {
        this.dropdownListBox.removeSelectionListener(this.dropdownListBoxSelectionListener);
        this.selectedItemModel.removePropertyChangeListener("value", this.selectedItemChangeListener);
    }

    void selectedItemChanged(PropertyChangeEvent event) {
        if (!this.dropdownListBox.isDisposed()) {
            this.selectedItemChanged_(event);
        }
    }

    private void selectedItemChanged_(PropertyChangeEvent event) {
        this.synchronizeListWidgetSelection();
    }

    private int indexOf(E item) {
        int len = this.listModel.size();
        int i = 0;
        while (i < len) {
            if (Tools.valuesAreEqual((Object)this.listModel.get(i), item)) {
                return i;
            }
            ++i;
        }
        if (item == null) {
            return -1;
        }
        return -1;
    }

    void dropDownListBoxSelectionChanged(SelectionEvent event) {
        if (!this.dropdownListBox.isDisposed()) {
            this.dropDownListBoxSelectionChanged_(event);
        }
    }

    void dropDownListBoxDoubleClicked(SelectionEvent event) {
        if (!this.dropdownListBox.isDisposed()) {
            this.dropDownListBoxSelectionChanged_(event);
        }
    }

    private void dropDownListBoxSelectionChanged_(SelectionEvent event) {
        this.selectedItemModel.setValue(this.getDropDownListBoxSelectedItem());
    }

    private E getDropDownListBoxSelectedItem() {
        int selectionIndex = this.dropdownListBox.getSelectionIndex();
        return (E)(selectionIndex == -1 ? null : this.listModel.get(selectionIndex));
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.selectedItemModel);
    }

    static interface DropDownListBox {
        public boolean isDisposed();

        public void addSelectionListener(SelectionListener var1);

        public void removeSelectionListener(SelectionListener var1);

        public int getSelectionIndex();

        public void select(int var1);

        public void deselect(int var1);

        public void deselectAll();
    }
}

