/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TableModelAdapter;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemoveListPane<T extends Model>
extends AddRemovePane<T> {
    private Table table;

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, ModifiablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, ModifiablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider, String helpId) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId);
    }

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, ModifiablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider, String helpId, boolean parentManagePane) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId, parentManagePane);
    }

    public AddRemoveListPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, ModifiablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveListPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, ModifiablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider, String helpId) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId);
    }

    private ColumnAdapter<Object> buildColumnAdapter() {
        return new ColumnAdapter<Object>(){

            @Override
            public ModifiablePropertyValueModel<?>[] cellModels(Object subject) {
                ModifiablePropertyValueModel[] valueHolders = new ModifiablePropertyValueModel[]{new SimplePropertyValueModel(subject)};
                return valueHolders;
            }

            @Override
            public int columnCount() {
                return 1;
            }

            @Override
            public String columnName(int columnIndex) {
                return "";
            }
        };
    }

    @Override
    protected void itemsAdded(ListAddEvent e) {
        super.itemsAdded(e);
        this.revalidateLayout();
    }

    @Override
    protected void itemsMoved(ListMoveEvent e) {
        super.itemsMoved(e);
        this.revalidateLayout();
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent e) {
        super.itemsRemoved(e);
        this.revalidateLayout();
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent e) {
        super.itemsReplaced(e);
        this.revalidateLayout();
    }

    @Override
    protected void listChanged(ListChangeEvent e) {
        super.listChanged(e);
        this.revalidateLayout();
    }

    @Override
    protected void listCleared(ListClearEvent e) {
        super.listCleared(e);
        this.revalidateLayout();
    }

    private void revalidateLayout() {
        SWTUtil.asyncExec(new Runnable(){

            public void run() {
                if (!AddRemoveListPane.this.table.isDisposed()) {
                    AddRemoveListPane.this.table.getParent().computeSize(-1, -1);
                    AddRemoveListPane.this.table.getParent().layout();
                }
            }
        });
    }

    private PropertyChangeListener buildSelectedItemPropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSelectedItemPropertyChangeListener_());
    }

    private PropertyChangeListener buildSelectedItemPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (AddRemoveListPane.this.table.isDisposed()) {
                    return;
                }
                AddRemoveListPane.this.getSelectionModel().setSelectedValue(e.getNewValue());
                AddRemoveListPane.this.updateButtons();
            }
        };
    }

    private TableModelAdapter.SelectionChangeListener<Object> buildSelectionListener() {
        return new TableModelAdapter.SelectionChangeListener<Object>(){

            @Override
            public void selectionChanged(TableModelAdapter.SelectionChangeEvent<Object> e) {
                AddRemoveListPane.this.selectionChanged();
            }
        };
    }

    private Composite addTableContainer(Composite container) {
        container = this.addPane(container, this.buildTableContainerLayout());
        container.setLayoutData((Object)new GridData(1808));
        return container;
    }

    private Layout buildTableContainerLayout() {
        return new Layout(){

            protected Point computeSize(Composite composite, int widthHint, int heightHint, boolean flushCache) {
                Table table = (Table)composite.getChildren()[0];
                TableColumn tableColumn = table.getColumn(0);
                int columnWidth = tableColumn.getWidth();
                this.packColumn(table);
                Point size = table.computeSize(-1, -1);
                if (widthHint != -1) {
                    size.x = widthHint;
                }
                if (heightHint != -1) {
                    size.y = heightHint;
                }
                table.setRedraw(false);
                table.setLayoutDeferred(true);
                tableColumn.setWidth(columnWidth);
                table.setLayoutDeferred(false);
                table.setRedraw(true);
                return size;
            }

            private boolean isVerticalScrollbarBarVisible(Table table, Rectangle clientArea) {
                int height = table.getItemCount() * table.getItemHeight();
                return clientArea.height < (height += table.getBorderWidth() * 2);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle bounds = composite.getClientArea();
                if (bounds.width > 0) {
                    Table table = (Table)composite.getChildren()[0];
                    table.setBounds(0, 0, bounds.width, bounds.height);
                    this.updateTableColumnWidth(table, bounds.width, this.isVerticalScrollbarBarVisible(table, bounds));
                }
            }

            private void packColumn(Table table) {
                TableColumn tableColumn = table.getColumn(0);
                table.setRedraw(false);
                table.setLayoutDeferred(true);
                tableColumn.pack();
                table.setLayoutDeferred(false);
                table.setRedraw(true);
                table.setData("column.width", (Object)tableColumn.getWidth());
            }

            private void updateTableColumnWidth(Table table, int width, boolean verticalScrollbarBarVisible) {
                width -= table.getBorderWidth() * 2;
                if (verticalScrollbarBarVisible) {
                    width -= table.getVerticalBar().getSize().x;
                }
                TableColumn tableColumn = table.getColumn(0);
                Integer columnWitdh = (Integer)table.getData("column.width");
                width = Math.max(width, columnWitdh);
                tableColumn.setWidth(width);
            }
        };
    }

    private ITableLabelProvider buildTableLabelProvider(IBaseLabelProvider labelProvider) {
        return new TableLabelProvider((ILabelProvider)labelProvider);
    }

    public Table getMainControl() {
        return this.table;
    }

    @Override
    protected void initializeMainComposite(Composite container, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, ModifiablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
        this.table = this.addUnmanagedTable(this.addTableContainer(container), 66306, helpId);
        TableModelAdapter<Object> model = TableModelAdapter.adapt(listHolder, this.getSelectedItemHolder(), this.table, this.buildColumnAdapter(), this.buildTableLabelProvider(labelProvider));
        model.addSelectionChangeListener(this.buildSelectionListener());
        selectedItemHolder.addPropertyChangeListener("value", this.buildSelectedItemPropertyChangeListener());
        this.initializeTable(this.table);
    }

    protected void initializeTable(Table table) {
        table.setData("column.width", (Object)new Integer(0));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
    }

    private void selectionChanged() {
        ModifiablePropertyValueModel<Object> selectedItemHolder = this.getSelectedItemHolder();
        ObjectListSelectionModel selectionModel = this.getSelectionModel();
        int selectionCount = this.table.getSelectionCount();
        if (selectionCount == 0) {
            selectedItemHolder.setValue(null);
            selectionModel.clearSelection();
        } else if (selectionCount != 1) {
            selectedItemHolder.setValue(null);
            selectionModel.clearSelection();
            int[] nArray = this.table.getSelectionIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                selectionModel.addSelectionInterval(index, index);
                ++n2;
            }
        } else {
            int selectedIndex = this.table.getSelectionIndex();
            Object selectedItem = this.getListHolder().get(selectedIndex);
            selectedItemHolder.setValue(selectedItem);
            selectionModel.setSelectedValue(selectedItem);
        }
        this.updateButtons();
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider labelProvider;

        TableLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.labelProvider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.labelProvider.getText(element);
        }
    }
}

