/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneListIterable;
import org.eclipse.jpt.common.utility.tests.internal.iterables.SnapshotCloneIterableTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotCloneListIterableTests
extends SnapshotCloneIterableTests {
    public SnapshotCloneListIterableTests(String name) {
        super(name);
    }

    public void testAdd() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildRemovingIterable(collection);
        String added = "xxxx";
        SnapshotCloneListIterableTests.assertFalse((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)added));
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("two")) continue;
            iterator.add(added);
        }
        SnapshotCloneListIterableTests.assertTrue((boolean)collection.contains(added));
        SnapshotCloneListIterableTests.assertFalse((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)added));
    }

    public void testMissingMutatorAdd() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterable(collection);
        SnapshotCloneListIterableTests.assertNotNull((Object)this.iterable.toString());
        String added = "xxxx";
        SnapshotCloneListIterableTests.assertFalse((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)added));
        boolean exCaught = false;
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("three")) continue;
            try {
                iterator.add(added);
                SnapshotCloneListIterableTests.fail();
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
        }
        SnapshotCloneListIterableTests.assertTrue((boolean)exCaught);
    }

    public void testSet() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildRemovingIterable(collection);
        String added = "xxxx";
        SnapshotCloneListIterableTests.assertFalse((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)added));
        SnapshotCloneListIterableTests.assertTrue((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)"two"));
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("two")) continue;
            iterator.set(added);
        }
        SnapshotCloneListIterableTests.assertTrue((boolean)collection.contains(added));
        SnapshotCloneListIterableTests.assertFalse((boolean)collection.contains("two"));
        SnapshotCloneListIterableTests.assertFalse((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)added));
        SnapshotCloneListIterableTests.assertTrue((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)"two"));
    }

    public void testMissingMutatorSet() {
        List<String> collection = this.buildCollection();
        this.iterable = this.buildIterable(collection);
        SnapshotCloneListIterableTests.assertNotNull((Object)this.iterable.toString());
        String added = "xxxx";
        SnapshotCloneListIterableTests.assertFalse((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)added));
        boolean exCaught = false;
        ListIterator iterator = (ListIterator)this.iterable.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("three")) continue;
            try {
                iterator.set(added);
                SnapshotCloneListIterableTests.fail();
            }
            catch (RuntimeException runtimeException) {
                exCaught = true;
            }
        }
        SnapshotCloneListIterableTests.assertTrue((boolean)exCaught);
    }

    @Override
    Iterable<String> buildIterable(List<String> c) {
        return new SnapshotCloneListIterable(c);
    }

    @Override
    Iterable<String> buildRemovingIterable(final List<String> c) {
        return new SnapshotCloneListIterable<String>(c){

            protected void add(int index, String element) {
                c.add(index, element);
            }

            protected void remove(int index) {
                c.remove(index);
            }

            protected void set(int index, String element) {
                c.set(index, element);
            }
        };
    }

    @Override
    Iterable<String> buildIterableWithRemover(List<String> c) {
        return new SnapshotCloneListIterable(c, this.buildMutator(c));
    }
}

