/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context;

import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.JavaEclipseLinkEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.JavaEclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.JavaEclipseLinkMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationOperation;
import org.eclipse.jpt.jpa.eclipselink.core.platform.EclipseLinkPlatform;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public abstract class EclipseLinkContextModelTestCase
extends ContextModelTestCase {
    protected JpaXmlResource eclipseLinkOrmXmlResource;

    protected EclipseLinkContextModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.eclipseLinkOrmXmlResource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
    }

    protected void tearDown() throws Exception {
        this.eclipseLinkOrmXmlResource = null;
        super.tearDown();
    }

    protected TestJpaProject buildJpaProject(String projectName, boolean autoBuild, IDataModel jpaConfig) throws Exception {
        TestJpaProject testJpaProject = super.buildJpaProject(projectName, autoBuild, jpaConfig);
        if (this.createEclipseLinkOrmXml()) {
            EclipseLinkOrmFileCreationOperation operation = new EclipseLinkOrmFileCreationOperation(this.buildEclipseLinkOrmConfig(testJpaProject));
            operation.execute(null, null);
        }
        return testJpaProject;
    }

    protected boolean createOrmXml() {
        return false;
    }

    protected boolean createEclipseLinkOrmXml() {
        return true;
    }

    protected IDataModel buildEclipseLinkOrmConfig(TestJpaProject testJpaProject) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        dataModel.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)testJpaProject.getProject().getFolder("src/META-INF").getFullPath());
        dataModel.setProperty("JpaFileCreationDataModelProperties.VERSION", (Object)this.getEclipseLinkSchemaVersion());
        dataModel.setProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", (Object)Boolean.TRUE);
        return dataModel;
    }

    protected String getEclipseLinkSchemaVersion() {
        return "1.0";
    }

    protected JpaPlatformDescription getJpaPlatformDescription() {
        return EclipseLinkPlatform.VERSION_1_0;
    }

    protected EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    protected JavaEclipseLinkEntity getJavaEntity() {
        return (JavaEclipseLinkEntity)this.getJavaPersistentType().getMapping();
    }

    protected JavaEclipseLinkEmbeddable getJavaEmbeddable() {
        return (JavaEclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
    }

    protected JavaEclipseLinkMappedSuperclass getJavaMappedSuperclass() {
        return (JavaEclipseLinkMappedSuperclass)this.getJavaPersistentType().getMapping();
    }

    protected JpaXmlResource getOrmXmlResource() {
        return this.eclipseLinkOrmXmlResource;
    }

    protected XmlEntityMappings getXmlEntityMappings() {
        return (XmlEntityMappings)super.getXmlEntityMappings();
    }

    protected EclipseLinkEntityMappings getEntityMappings() {
        return (EclipseLinkEntityMappings)super.getEntityMappings();
    }
}

