/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.JoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyEnumerated2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyTemporal2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TemporalType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkJoinFetchAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaManyToManyMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0JavaManyToManyMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithJoinFetchManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "org.eclipse.persistence.annotations.JoinFetch"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("@JoinFetch").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Collection<AnnotationTestType> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private String address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityPropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    public void testGetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.INNER);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(JoinFetchType.OUTER);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        joinFetchAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
    }

    public void testSetJoinFetchValue() throws Exception {
        this.createTestEntityWithJoinFetchManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkRelationshipMapping manyToManyMapping = (EclipseLinkRelationshipMapping)persistentAttribute.getMapping();
        EclipseLinkJoinFetch contextJoinFetch = manyToManyMapping.getJoinFetch();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkJoinFetchAnnotation joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.OUTER, (Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch"));
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)contextJoinFetch.getValue());
        contextJoinFetch.setValue(EclipseLinkJoinFetchType.INNER);
        joinFetchAnnotation = (EclipseLinkJoinFetchAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.JoinFetch");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)JoinFetchType.INNER, (Object)joinFetchAnnotation.getValue());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextJoinFetch.getValue());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"employees", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"employees", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        resourceField.addAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        resourceField.removeAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKey"));
        manyToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getSpecifiedMapKey());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        manyToManyMapping.setSpecifiedMapKey(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKey());
        mapKey = (MapKeyAnnotation)resourceField.getAnnotation("javax.persistence.MapKey");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)mapKey.getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping2_0 = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"employees", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping2_0 = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        manyToManyMapping2_0.setSpecifiedTargetEntity("Address");
        mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"employees", (String)((String)mapKeyNames.next()));
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        manyToManyMapping2_0.setSpecifiedTargetEntity("String");
        mapKeyNames = manyToManyMapping2_0.getCandidateMapKeyNames().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        resourceField.addAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClassAnnotation = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)mapKeyClassAnnotation);
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"myMapKeyClass", (String)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"myMapKeyClass", (String)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        resourceField.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
        manyToManyMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"String", (String)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        manyToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedMapKeyClass());
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getDefaultMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass("foo");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyClass());
        manyToManyMapping.setSpecifiedMapKeyClass(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"java.lang.Integer", (String)manyToManyMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        this.addXmlClassRef("test.PrintQueue");
        this.addXmlClassRef("test.PrintJob");
        JavaPersistentType printQueuePersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintQueue");
        ManyToManyMapping jobsMapping = (ManyToManyMapping)printQueuePersistentType.getAttributeNamed("jobs").getMapping();
        JavaPersistentType printJobPersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ManyToManyMapping queuesMapping = (ManyToManyMapping)printJobPersistentType.getAttributeNamed("queues").getMapping();
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        OrderColumn2_0 jobsOrderColumn = jobsOrderable.getOrderColumn();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals(null, (String)jobsOrderColumn.getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTable());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        OrderColumn2_0 queuesOrderColumn = queuesOrderable.getOrderColumn();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals(null, (String)queuesOrderColumn.getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTable());
        jobsOrderColumn.setSpecifiedName("FOO");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)jobsOrderColumn.getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTable());
        queuesOrderColumn.setSpecifiedName("BAR");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BAR", (String)queuesOrderColumn.getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTable());
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_TABLE_PrintQueue", (String)jobsOrderColumn.getTable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_TABLE_PrintQueue", (String)queuesOrderColumn.getTable());
        ((Entity)printQueuePersistentType.getMapping()).getTable().setSpecifiedName("OTHER_TABLE");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)jobsOrderColumn.getTable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)queuesOrderColumn.getTable());
        queuesMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)jobsOrderColumn.getTable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)queuesOrderColumn.getTable());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany(mappedBy=\"queues\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintQueue> queues;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testGetMapKeyColumnMappedByStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        manyToManyMapping.getRelationship().setStrategyToMappedBy();
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("employees");
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"Address_AnnotationTestType", (String)manyToManyMapping.getMapKeyColumn().getTable());
        PersistentType persistentType = this.getPersistenceUnit().getPersistentType("test.Address");
        ManyToManyMapping owningManyToManyMapping = (ManyToManyMapping)persistentType.getAttributeNamed("employees").getMapping();
        ((JoinTableRelationshipStrategy)owningManyToManyMapping.getRelationship().getStrategy()).getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnJoinTableStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToManyMapping2_0 manyToManyMapping = (ManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)manyToManyMapping.getMapKeyColumn().getTable());
        manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)manyToManyMapping.getMapKeyColumn().getTable());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getSpecifiedName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getMapKeyColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"addresses_KEY", (String)manyToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testMapKeySpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        this.addXmlClassRef("test.PropertyInfo");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(1, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(1, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        resourceField.removeAnnotation(0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().getSpecifiedClassRefs().iterator();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"parcels", (String)resourceField.getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getSpecifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.getOverridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("key.state.foo");
        attributeOverride = (AttributeOverrideAnnotation)resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator().next()).convertToVirtual();
        attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.address", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.getVirtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyManyToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = manyToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        ListIterator specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.moveAnnotation(1, 0, "javax.persistence.AttributeOverride");
        this.getJpaProject().synchronizeContextModel();
        ListIterator attributeOverrides = resourceField.getAnnotations("javax.persistence.AttributeOverride").iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.getSpecifiedOverrides().iterator();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)specifiedOverrides.hasNext());
    }

    public void testSetSpecifiedMapKeyEnumerated() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        manyToManyMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated");
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)enumerated);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals(null, (Object)enumerated.getValue());
        ((BaseEnumeratedConverter)manyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING, (Object)enumerated.getValue());
        ((BaseEnumeratedConverter)manyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)enumerated.getValue());
        manyToManyMapping.setMapKeyConverter(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
    }

    public void testGetSpecifiedMapKeyEnumeratedUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyEnumerated2_0Annotation enumerated = (MapKeyEnumerated2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyEnumerated");
        enumerated.setValue(org.eclipse.jpt.jpa.core.resource.java.EnumType.STRING);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)manyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        enumerated.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyEnumerated"));
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)((BaseEnumeratedConverter)manyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        EclipseLink2_0JavaManyToManyMappingTests.assertSame((Object)manyToManyMapping, (Object)persistentAttribute.getMapping());
    }

    public void testSetMapKeyTemporal() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        manyToManyMapping.setMapKeyConverter(BaseTemporalConverter.class);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.getAnnotation("javax.persistence.MapKeyTemporal");
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)temporal);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals(null, (Object)temporal.getValue());
        ((BaseTemporalConverter)manyToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)TemporalType.TIME, (Object)temporal.getValue());
        ((BaseTemporalConverter)manyToManyMapping.getMapKeyConverter()).setTemporalType(null);
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
    }

    public void testGetMapKeyTemporalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidGenericMapManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaManyToManyMapping2_0 manyToManyMapping = (JavaManyToManyMapping2_0)persistentAttribute.getMapping();
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKeyConverter().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        MapKeyTemporal2_0Annotation temporal = (MapKeyTemporal2_0Annotation)resourceField.addAnnotation("javax.persistence.MapKeyTemporal");
        temporal.setValue(TemporalType.TIME);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)manyToManyMapping.getMapKeyConverter()).getTemporalType());
        temporal.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToManyMappingTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapKeyTemporal"));
        EclipseLink2_0JavaManyToManyMappingTests.assertNull((Object)((BaseTemporalConverter)manyToManyMapping.getMapKeyConverter()).getTemporalType());
        EclipseLink2_0JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        EclipseLink2_0JavaManyToManyMappingTests.assertSame((Object)manyToManyMapping, (Object)persistentAttribute.getMapping());
    }
}

