/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.persistence;

import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class PersistenceTests
extends ContextModelTestCase {
    public PersistenceTests(String name) {
        super(name);
    }

    protected Persistence persistence() {
        return this.getRootContextNode().getPersistenceXml().getPersistence();
    }

    public void testUpdateAddPersistenceUnit() throws Exception {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.getRootContextNode().getPersistenceXml().getPersistence();
        xmlPersistence.getPersistenceUnits().clear();
        PersistenceTests.assertEquals((int)0, (int)persistence.getPersistenceUnitsSize());
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
        xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test2");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
    }

    public void testModifyAddPersistencUnit() {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.persistence();
        xmlPersistence.getPersistenceUnits().clear();
        PersistenceTests.assertEquals((int)0, (int)persistence.getPersistenceUnitsSize());
        persistence.addPersistenceUnit();
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
        boolean exception = false;
        try {
            persistence.addPersistenceUnit();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exception = true;
        }
        PersistenceTests.assertTrue((boolean)exception);
    }

    public void testUpdateRemovePersistenceUnit() throws Exception {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.getRootContextNode().getPersistenceXml().getPersistence();
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)2, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
        xmlPersistenceUnit = (XmlPersistenceUnit)xmlPersistence.getPersistenceUnits().get(0);
        xmlPersistence.getPersistenceUnits().remove((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)1, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
        xmlPersistenceUnit = (XmlPersistenceUnit)xmlPersistence.getPersistenceUnits().get(0);
        xmlPersistence.getPersistenceUnits().remove((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)0, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)0, (int)persistence.getPersistenceUnitsSize());
    }

    public void testModifyRemovePersistenceUnit() {
        XmlPersistence xmlPersistence = this.getXmlPersistence();
        Persistence persistence = this.persistence();
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        xmlPersistenceUnit.setName("test");
        xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        PersistenceTests.assertEquals((int)2, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
        persistence.removePersistenceUnit(0);
        PersistenceTests.assertEquals((int)1, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)1, (int)persistence.getPersistenceUnitsSize());
        persistence.removePersistenceUnit(0);
        PersistenceTests.assertEquals((int)0, (int)xmlPersistence.getPersistenceUnits().size());
        PersistenceTests.assertEquals((int)0, (int)persistence.getPersistenceUnitsSize());
    }
}

