/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaDerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsId2_0Annotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaManyToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaManyToOneMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdDerivedIdentity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : ormPersistentType.getAttributes()) {
            each.addToXml();
        }
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JoinColumnRelationshipStrategy joinColumns = manyToOneMapping.getRelationship().getJoinColumnStrategy();
        joinColumns.addSpecifiedJoinColumn(0);
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)manyToOneMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceField.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceField.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceField.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        annotation.setValue("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        resourceField.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("foo");
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceField.getAnnotation("javax.persistence.MapsId");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)annotation);
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName("bar");
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaManyToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedIdAttributeName(null);
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        JavaDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceField.addAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceField.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceField.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        JavaDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("oneToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("manyToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedIdAttributeName());
        contextAttribute.setMappingKey("id");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaIdMapping));
        contextAttribute.setMappingKey("manyToOne");
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaManyToOneMapping2_0));
        contextAttribute.setMappingKey("basic");
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.MapsId"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)(contextAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping2_0 mapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        ManyToOneRelationship2_0 rel = (ManyToOneRelationship2_0)mapping.getRelationship();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)((JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE)).getFields().iterator().next();
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        ManyToOneMapping2_0 mapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        ManyToOneRelationship2_0 rel = (ManyToOneRelationship2_0)mapping.getRelationship();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceField.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation(0, "javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceField.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaManyToOneMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
        GenericJavaManyToOneMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaManyToOneMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaManyToOneMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
    }
}

