/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlElementCollection;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlElementCollection_2_0;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmElementCollectionMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";

    public GenericOrmElementCollectionMapping2_0Tests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityWithElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.FetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)");
                sb.append(CR);
                sb.append("    private java.util.Collection<Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.FetchType", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonGenericElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithGenericBasicElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<String> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapElementCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createSelfReferentialElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.List<Foo> elementCollection;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)elementCollection.getName());
        elementCollection.setName("newName");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newName", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newName", (String)elementCollection.getName());
        elementCollection.setName(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)elementCollection.getName());
        ormElementCollectionMapping.setName("newName");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newName", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newName", (String)elementCollection.getName());
        ormElementCollectionMapping.setName(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getName());
    }

    public void testMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "elementCollection");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        ormElementCollectionMapping.setName("foo");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"address", (String)virtualElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)virtualElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)virtualElementCollectionMapping.getSpecifiedTargetClass());
        ormPersistentAttribute = ormPersistentAttribute.addToXml();
        OrmElementCollectionMapping2_0 specifiedElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"address", (String)specifiedElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (Object)specifiedElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)specifiedElementCollectionMapping.getDefaultFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (String)specifiedElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"test.Address", (String)specifiedElementCollectionMapping.getDefaultTargetClass());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.addToXml("elementCollection");
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"address", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityWithElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("address"), "elementCollection");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"address", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        elementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)elementCollectionMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.getSpecifiedAttributesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.getSpecifiedAttributes().iterator().next());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)elementCollection.getFetch());
        elementCollection.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)elementCollection.getFetch());
        elementCollection.setFetch(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
        ormElementCollectionMapping.setSpecifiedFetch(FetchType.EAGER);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)elementCollection.getFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        ormElementCollectionMapping.setSpecifiedFetch(FetchType.LAZY);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)elementCollection.getFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getSpecifiedFetch());
        ormElementCollectionMapping.setSpecifiedFetch(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
    }

    public void testUpdateSpecifiedTargetClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getTargetClass());
        elementCollection.setTargetClass("newTargetClass");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)ormElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        elementCollection.setTargetClass(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testModifySpecifiedTargetClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getTargetClass());
        ormElementCollectionMapping.setSpecifiedTargetClass("newTargetClass");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)ormElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"newTargetClass", (String)elementCollection.getTargetClass());
        ormElementCollectionMapping.setSpecifiedTargetClass(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedTargetClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getTargetClass());
    }

    public void testGetValueTypeEmbeddable() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeEntity() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeNone() throws Exception {
        this.createTestEntityWithNonGenericElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.NO_TYPE, (Object)elementCollectionMapping.getValueType());
        elementCollectionMapping.setSpecifiedTargetClass("test.Address");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.EMBEDDABLE_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testGetValueTypeBasic() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)CollectionMapping.Type.BASIC_TYPE, (Object)elementCollectionMapping.getValueType());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 ormElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKey());
        elementCollection.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNotNull((Object)elementCollection.getMapKey());
        elementCollection.getMapKey().setName("myMapKey");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)elementCollection.getMapKey().getName());
        elementCollection.getMapKey().setName(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKey().getName());
        elementCollection.getMapKey().setName("myMapKey");
        elementCollection.setMapKey(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)virtualElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)virtualElementCollectionMapping.getMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualElementCollectionMapping.isPkMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualElementCollectionMapping.isCustomMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualElementCollectionMapping.isNoMapKey());
        javaElementCollectionMapping.setPkMapKey(true);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (String)virtualElementCollectionMapping.getMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualElementCollectionMapping.isPkMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualElementCollectionMapping.isCustomMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualElementCollectionMapping.isNoMapKey());
        javaElementCollectionMapping.setCustomMapKey(true);
        javaElementCollectionMapping.setSpecifiedMapKey(ATTRIBUTE_OVERRIDE_NAME);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualElementCollectionMapping.getMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualElementCollectionMapping.isPkMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualElementCollectionMapping.isCustomMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualElementCollectionMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 ormElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 xmlElementCollection = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)xmlElementCollection.getMapKey());
        ormElementCollectionMapping.setSpecifiedMapKey("myMapKey");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"myMapKey", (String)xmlElementCollection.getMapKey().getName());
        ormElementCollectionMapping.setSpecifiedMapKey(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKey());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)ormElementCollectionMapping.isPkMapKey());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualElementCollectionMapping.getCandidateMapKeyNames().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualElementCollectionMapping.getCandidateMapKeyNames().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaElementCollectionMapping.setSpecifiedTargetClass("test.Address");
        mapKeyNames = virtualElementCollectionMapping.getCandidateMapKeyNames().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        virtualElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = virtualElementCollectionMapping.getCandidateMapKeyNames().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        virtualElementCollectionMapping.setSpecifiedTargetClass("test.Address");
        mapKeyNames = virtualElementCollectionMapping.getCandidateMapKeyNames().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        virtualElementCollectionMapping.setSpecifiedTargetClass("String");
        mapKeyNames = virtualElementCollectionMapping.getCandidateMapKeyNames().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKeyClass());
        elementCollection.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNotNull((Object)elementCollection.getMapKeyClass());
        elementCollection.getMapKeyClass().setClassName("String");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)elementCollection.getMapKeyClass().getClassName());
        elementCollection.getMapKeyClass().setClassName(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKeyClass().getClassName());
        elementCollection.getMapKeyClass().setClassName("String");
        elementCollection.setMapKeyClass(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ElementCollectionMapping2_0 virtualElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.String", (String)virtualElementCollectionMapping.getMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)virtualElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.String", (String)virtualElementCollectionMapping.getDefaultMapKeyClass());
        javaElementCollectionMapping.setSpecifiedMapKeyClass("Integer");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"Integer", (String)virtualElementCollectionMapping.getMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"Integer", (String)virtualElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"java.lang.String", (String)virtualElementCollectionMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection elementCollection = (XmlElementCollection)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKeyClass());
        ormElementCollectionMapping.setSpecifiedMapKeyClass("String");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"String", (String)elementCollection.getMapKeyClass().getClassName());
        ormElementCollectionMapping.setSpecifiedMapKeyClass(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedMapKeyClass());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollection.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        orderable.setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getDefaultName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)orderColumn.getTable());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        OrmElementCollectionMapping2_0 elementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        Orderable2_0 orderable = (Orderable2_0)elementCollectionMapping.getOrderable();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaElementCollectionMapping.getOrderable()).setOrderColumnOrdering(true);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isNoOrdering());
        ormPersistentAttribute.removeFromXml();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("addresses");
        ElementCollectionMapping2_0 virtualCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute2.getMapping();
        orderable = (Orderable2_0)virtualCollectionMapping.getOrderable();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)orderable.isNoOrdering());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)orderable.getOrderColumn().getTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderable.getOrderColumn().getName());
        ((Orderable2_0)javaElementCollectionMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)orderable.getOrderColumn().getTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)orderable.getOrderColumn().getName());
    }

    public void testVirtualValueColumnDefaults() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        ElementCollectionMapping2_0 addressesVirtualMapping = (ElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column virtualColumn = addressesVirtualMapping.getValueColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses", (String)virtualColumn.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (String)virtualColumn.getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualColumn.isInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualColumn.isUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualColumn.isNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualColumn.isUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)255, (int)virtualColumn.getLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getScale());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getValueColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getValueColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getValueColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getValueColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getValueColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getValueColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)virtualColumn.getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)virtualColumn.getSpecifiedUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)45, (Object)virtualColumn.getSpecifiedLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)46, (Object)virtualColumn.getSpecifiedPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)47, (Object)virtualColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullColumnDefaults() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        OrmColumn ormColumn = addressesVirtualMapping.getValueColumn();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getValueColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getValueColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getValueColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getValueColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getValueColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getValueColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getValueColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses", (String)ormColumn.getDefaultName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getDefaultTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedLength());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualValueColumnTable() throws Exception {
        this.createTestEntityWithGenericBasicElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ElementCollectionMapping2_0 addressesVirtualMapping = (ElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column virtualColumn = addressesVirtualMapping.getValueColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getTable());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getCollectionTable().setSpecifiedName("JAVA_COLLECTION_TABLE");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"JAVA_COLLECTION_TABLE", (String)virtualColumn.getTable());
        javaElementCollectionMapping.getValueColumn().setSpecifiedTable("JAVA_TABLE");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"JAVA_TABLE", (String)virtualColumn.getTable());
        addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        virtualColumn = addressesVirtualMapping.getValueColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)virtualColumn.getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getDefaultTable());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormElementCollectionMapping.getValueAttributeOverrideContainer();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).setName("BAZ");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)elementCollectionResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormElementCollectionMapping.getValueAttributeOverrideContainer();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        elementCollectionResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)elementCollectionResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        elementCollectionResource.getAttributeOverrides().remove(0);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.getSpecifiedOverrides().iterator().hasNext());
    }

    public void testElementCollectionMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)2, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        ormElementCollectionMapping.setName("foo");
        OrmAttributeOverrideContainer attributeOverrideContainer = ormElementCollectionMapping.getValueAttributeOverrideContainer();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"foo", (String)ormElementCollectionMapping.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getSpecifiedFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormElementCollectionMapping.getFetch());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.getSpecifiedOverrides().iterator().hasNext());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.getVirtualOverrides().iterator().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableElementCollectionMapping();
        this.createTestTargetEmbeddableAddress();
        this.createTestEmbeddableState();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType persistentType3 = this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("addresses");
        ElementCollectionMapping2_0 elementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        AttributeOverrideContainer attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        ReadOnlyAttributeOverride attributeOverride = (ReadOnlyAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        ListIterator virtualOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        attributeOverride = (ReadOnlyAttributeOverride)virtualOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)attributeOverride.getName());
        attributeOverride = (ReadOnlyAttributeOverride)virtualOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)attributeOverride.getName());
        attributeOverride = (ReadOnlyAttributeOverride)virtualOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaColumn javaAttributeOverrideColumn = ((JavaAttributeOverride)javaElementCollectionMapping.getValueAttributeOverrideContainer().getSpecifiedOverrides().iterator().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTable("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType3.getJavaPersistentType().getAttributeNamed("name").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.getSpecifiedOverrides().iterator();
        attributeOverride = (ReadOnlyAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        virtualOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        attributeOverride = (ReadOnlyAttributeOverride)virtualOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)attributeOverride.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (ReadOnlyAttributeOverride)virtualOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)attributeOverride.getName());
        attributeOverride = (ReadOnlyAttributeOverride)virtualOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("addresses").addToXml();
        elementCollectionMapping = (OrmElementCollectionMapping2_0)persistentType.getAttributeNamed("addresses").getMapping();
        attributeOverrideContainer = elementCollectionMapping.getValueAttributeOverrideContainer();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        VirtualAttributeOverride virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualOverride.getName());
        virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)virtualOverride.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"MY_STATE_COLUMN", (String)virtualOverride.getColumn().getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualOverride.getColumn().getTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (String)virtualOverride.getColumn().getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualOverride.getColumn().isInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualOverride.getColumn().isUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualOverride.getColumn().isUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualOverride.getColumn().isNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)255, (int)virtualOverride.getColumn().getLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)virtualOverride.getColumn().getPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)virtualOverride.getColumn().getScale());
        virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)virtualOverride.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualOverride.getColumn().getDefaultTable());
        virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)virtualOverride.getName());
        ((VirtualAttributeOverride)attributeOverrideContainer.getVirtualOverrides().iterator().next()).convertToSpecified();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.getOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.getSpecifiedOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.getVirtualOverridesSize());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)((AttributeOverride)attributeOverrideContainer.getSpecifiedOverrides().iterator().next()).getName());
        virtualAttributeOverrides = attributeOverrideContainer.getVirtualOverrides().iterator();
        virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.name", (String)virtualOverride.getName());
        virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"state.abbr", (String)virtualOverride.getName());
        virtualOverride = (VirtualAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"zip", (String)virtualOverride.getName());
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        ElementCollectionMapping2_0 addressesVirtualMapping = (ElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column virtualColumn = addressesVirtualMapping.getMapKeyColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)virtualColumn.getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals(null, (String)virtualColumn.getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualColumn.isInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualColumn.isUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertTrue((boolean)virtualColumn.isNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)virtualColumn.isUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)255, (int)virtualColumn.getLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)virtualColumn.getScale());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)virtualColumn.getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)virtualColumn.getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualColumn.getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)virtualColumn.getSpecifiedNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)virtualColumn.getSpecifiedUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)45, (Object)virtualColumn.getSpecifiedLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)46, (Object)virtualColumn.getSpecifiedPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)47, (Object)virtualColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        OrmElementCollectionMapping2_0 addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedTable("FOO_TABLE");
        javaElementCollectionMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)ormColumn.getDefaultTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedName());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getColumnDefinition());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedNullable());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUnique());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedLength());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapElementCollectionMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute addressesPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ElementCollectionMapping2_0 addressesVirtualMapping = (ElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        Column virtualColumn = addressesVirtualMapping.getMapKeyColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getTable());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getTable());
        JavaElementCollectionMapping2_0 javaElementCollectionMapping = (JavaElementCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaElementCollectionMapping.getCollectionTable().setSpecifiedName("JAVA_COLLECTION_TABLE");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"JAVA_COLLECTION_TABLE", (String)virtualColumn.getTable());
        javaElementCollectionMapping.getMapKeyColumn().setSpecifiedTable("JAVA_TABLE");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"JAVA_TABLE", (String)virtualColumn.getTable());
        addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "elementCollection");
        addressesVirtualMapping = (OrmElementCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        virtualColumn = addressesVirtualMapping.getMapKeyColumn();
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)virtualColumn.getSpecifiedTable());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"AnnotationTestType_addresses", (String)virtualColumn.getDefaultTable());
    }

    public void testSelfReferentialElementCollectionMapping() throws Exception {
        this.createSelfReferentialElementCollection();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Foo");
        ElementCollectionMapping2_0 mapping = (ElementCollectionMapping2_0)persistentType.getAttributeNamed("elementCollection").getMapping();
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)mapping.getAllOverridableAttributeMappingNames().iterator().hasNext());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyEnumerated());
        elementCollectionResource.setMapKeyEnumerated(org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormElementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL, (Object)elementCollectionResource.getMapKeyEnumerated());
        elementCollectionResource.setMapKeyEnumerated(org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)ormElementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING, (Object)elementCollectionResource.getMapKeyEnumerated());
        elementCollectionResource.setMapKeyEnumerated(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyEnumerated());
        ormElementCollectionMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)ormElementCollectionMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.ORDINAL);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.ORDINAL, (Object)elementCollectionResource.getMapKeyEnumerated());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormElementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ((BaseEnumeratedConverter)ormElementCollectionMapping.getMapKeyConverter()).setSpecifiedEnumType(EnumType.STRING);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.EnumType.STRING, (Object)elementCollectionResource.getMapKeyEnumerated());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)((BaseEnumeratedConverter)ormElementCollectionMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ormElementCollectionMapping.setMapKeyConverter(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyEnumerated());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
    }

    public void testUpdateSpecifiedTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyTemporal());
        elementCollectionResource.setMapKeyTemporal(TemporalType.DATE);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)TemporalType.DATE, (Object)elementCollectionResource.getMapKeyTemporal());
        elementCollectionResource.setMapKeyTemporal(TemporalType.TIME);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)elementCollectionResource.getMapKeyTemporal());
        elementCollectionResource.setMapKeyTemporal(TemporalType.TIMESTAMP);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)elementCollectionResource.getMapKeyTemporal());
        elementCollectionResource.setMapKeyTemporal(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyTemporal());
    }

    public void testModifySpecifiedTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        OrmElementCollectionMapping2_0 ormElementCollectionMapping = (OrmElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyTemporal());
        ormElementCollectionMapping.setMapKeyConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)TemporalType.DATE, (Object)elementCollectionResource.getMapKeyTemporal());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).getTemporalType());
        ((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)elementCollectionResource.getMapKeyTemporal());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormElementCollectionMapping.getMapKeyConverter()).getTemporalType());
        ormElementCollectionMapping.setMapKeyConverter(null);
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)elementCollectionResource.getMapKeyTemporal());
        GenericOrmElementCollectionMapping2_0Tests.assertNull((Object)ormElementCollectionMapping.getMapKeyConverter().getType());
    }

    public void testAddSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 ormElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        JoinColumn joinColumn = ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        JoinColumn joinColumn2 = ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(1)).getName());
        JoinColumn joinColumn3 = ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)joinColumn2, joinColumns.next());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)joinColumn3, joinColumns.next());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 ormElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)elementCollectionResource.getMapKeyJoinColumns().size());
        ormElementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)2, (int)elementCollectionResource.getMapKeyJoinColumns().size());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(1)).getName());
        ormElementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)1, (int)elementCollectionResource.getMapKeyJoinColumns().size());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        ormElementCollectionMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)0, (int)elementCollectionResource.getMapKeyJoinColumns().size());
    }

    public void testMoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 ormElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        ormElementCollectionMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((int)3, (int)elementCollectionResource.getMapKeyJoinColumns().size());
        ormElementCollectionMapping.moveSpecifiedMapKeyJoinColumn(2, 0);
        ListIterator joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(2)).getName());
        ormElementCollectionMapping.moveSpecifiedMapKeyJoinColumn(0, 1);
        joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(2)).getName());
    }

    public void testUpdateMapKeyJoinColumns() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "elementCollection");
        ElementCollectionMapping2_0 ormElementCollectionMapping = (ElementCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlElementCollection_2_0 elementCollectionResource = (XmlElementCollection_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getElementCollections().get(0);
        elementCollectionResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        elementCollectionResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        elementCollectionResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)elementCollectionResource.getMapKeyJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        elementCollectionResource.getMapKeyJoinColumns().move(2, 0);
        joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        elementCollectionResource.getMapKeyJoinColumns().move(0, 1);
        joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAR", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        elementCollectionResource.getMapKeyJoinColumns().remove(1);
        joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"FOO", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        elementCollectionResource.getMapKeyJoinColumns().remove(1);
        joinColumns = ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmElementCollectionMapping2_0Tests.assertEquals((String)"BAZ", (String)((JoinColumn)joinColumns.next()).getName());
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        elementCollectionResource.getMapKeyJoinColumns().remove(0);
        GenericOrmElementCollectionMapping2_0Tests.assertFalse((boolean)ormElementCollectionMapping.getSpecifiedMapKeyJoinColumns().iterator().hasNext());
    }
}

