/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.eclipselink.core.ELJaxbPlatform;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlDiscriminatorValue;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorValueAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlDiscriminatorValueTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlDiscriminatorValueTests(String name) {
        super(name);
    }

    @Override
    protected JaxbPlatformDescription getPlatform() {
        return ELJaxbPlatform.VERSION_2_2;
    }

    private ICompilationUnit createTypeWithXmlDiscriminatorValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlDiscriminatorValue").append(CR);
            }
        });
    }

    public void testModifyValue() throws Exception {
        this.createTypeWithXmlDiscriminatorValue();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        ELXmlDiscriminatorValue discValue = classMapping.getXmlDiscriminatorValue();
        XmlDiscriminatorValueAnnotation annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)discValue.getValue());
        discValue.setValue("foo");
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"foo", (String)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"foo", (String)discValue.getValue());
        discValue.setValue("");
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"", (String)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"", (String)discValue.getValue());
        discValue.setValue(null);
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)discValue.getValue());
    }

    public void testUpdateValue() throws Exception {
        this.createTypeWithXmlDiscriminatorValue();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        ELClassMapping classMapping = (ELClassMapping)jaxbClass.getMapping();
        ELXmlDiscriminatorValue discValue = classMapping.getXmlDiscriminatorValue();
        XmlDiscriminatorValueAnnotation annotation = (XmlDiscriminatorValueAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)discValue.getValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlDiscriminatorValueTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue", "foo");
            }
        });
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"foo", (String)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"foo", (String)discValue.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlDiscriminatorValueTests.this.setMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue", "");
            }
        });
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"", (String)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertEquals((String)"", (String)discValue.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlDiscriminatorValueTests.this.removeMemberValuePair(declaration, "org.eclipse.persistence.oxm.annotations.XmlDiscriminatorValue");
            }
        });
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)annotation.getValue());
        ELJavaXmlDiscriminatorValueTests.assertNull((Object)discValue.getValue());
    }
}

