/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.v2_2.ELJaxb_2_2_PlatformDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlDiscriminatorNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java.ELJaxbJavaResourceModelTestCase;

public class XmlDiscriminatorNodeAnnotationTests
extends ELJaxbJavaResourceModelTestCase {
    public XmlDiscriminatorNodeAnnotationTests(String name) {
        super(name);
    }

    @Override
    protected AnnotationDefinition[] annotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getAnnotationDefinitions();
    }

    @Override
    protected NestableAnnotationDefinition[] nestableAnnotationDefinitions() {
        return ELJaxb_2_2_PlatformDefinition.instance().getNestableAnnotationDefinitions();
    }

    private ICompilationUnit createTestXmlDiscriminatorNodeWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlDiscriminatorNode(\"foo\")");
            }
        });
    }

    private XmlDiscriminatorNodeAnnotation getXmlDiscriminatorNodeAnnotation(JavaResourceType resourceType) {
        return (XmlDiscriminatorNodeAnnotation)resourceType.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlDiscriminatorNode");
    }

    public void testValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlDiscriminatorNodeWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlDiscriminatorNodeAnnotation annotation = this.getXmlDiscriminatorNodeAnnotation(resourceType);
        XmlDiscriminatorNodeAnnotationTests.assertEquals((String)"foo", (String)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorNode(\"foo\")", cu);
        annotation.setValue("bar");
        XmlDiscriminatorNodeAnnotationTests.assertEquals((String)"bar", (String)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorNode(\"bar\")", cu);
        annotation.setValue("");
        XmlDiscriminatorNodeAnnotationTests.assertEquals((String)"", (String)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorNode(\"\")", cu);
        annotation.setValue(null);
        XmlDiscriminatorNodeAnnotationTests.assertNull((Object)annotation.getValue());
        this.assertSourceContains("@XmlDiscriminatorNode", cu);
        this.assertSourceDoesNotContain("@XmlDiscriminatorNode(", cu);
    }
}

