/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.resource.java.ELJaxbJavaResourceModelTestCase;

public class XmlPathAnnotationTests
extends ELJaxbJavaResourceModelTestCase {
    public XmlPathAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlPath() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlPath"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlPath");
            }
        });
    }

    private ICompilationUnit createTestXmlPathWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlPath"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlPath(\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestXmlPaths() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.oxm.annotations.XmlPaths", "org.eclipse.persistence.oxm.annotations.XmlPath"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlPaths({@XmlPath,@XmlPath})");
            }
        });
    }

    private XmlPathAnnotation getXmlPathAnnotation(JavaResourceAttribute resourceAttribute) {
        return this.getXmlPathAnnotation(resourceAttribute, 0);
    }

    private XmlPathAnnotation getXmlPathAnnotation(JavaResourceAttribute resourceAttribute, int index) {
        return (XmlPathAnnotation)resourceAttribute.getAnnotation(index, "org.eclipse.persistence.oxm.annotations.XmlPath");
    }

    public void testValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlPathWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlPathAnnotation annotation = this.getXmlPathAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlPathAnnotationTests.assertEquals((String)"foo", (String)annotation.getValue());
        this.assertSourceContains("@XmlPath(\"foo\")", cu);
        annotation.setValue("bar");
        XmlPathAnnotationTests.assertEquals((String)"bar", (String)annotation.getValue());
        this.assertSourceContains("@XmlPath(\"bar\")", cu);
        annotation.setValue("");
        XmlPathAnnotationTests.assertEquals((String)"", (String)annotation.getValue());
        this.assertSourceContains("@XmlPath(\"\")", cu);
        annotation.setValue(null);
        XmlPathAnnotationTests.assertNull((Object)annotation.getValue());
        this.assertSourceContains("@XmlPath", cu);
        this.assertSourceDoesNotContain("@XmlPath(", cu);
    }

    public void testContainedValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlPaths();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlPathAnnotation annotation = this.getXmlPathAnnotation((JavaResourceAttribute)resourceAttribute);
        XmlPathAnnotationTests.assertNull((Object)annotation.getValue());
        this.assertSourceContains("@XmlPaths({@XmlPath,@XmlPath})", cu);
        annotation.setValue("foo");
        XmlPathAnnotationTests.assertEquals((String)"foo", (String)annotation.getValue());
        this.assertSourceContains("@XmlPaths({@XmlPath(\"foo\"),@XmlPath})", cu);
        annotation.setValue(null);
        XmlPathAnnotationTests.assertNull((Object)annotation.getValue());
        this.assertSourceContains("@XmlPaths({@XmlPath,@XmlPath})", cu);
    }

    public void testContained() throws Exception {
        ICompilationUnit cu = this.createTestXmlPath();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlPathAnnotationTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlPath"));
        resourceAttribute.addAnnotation(1, "org.eclipse.persistence.oxm.annotations.XmlPath");
        XmlPathAnnotationTests.assertEquals((int)2, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlPath"));
        this.assertSourceContains("@XmlPaths({ @XmlPath, @XmlPath })", cu);
        XmlPathAnnotation annotation1 = this.getXmlPathAnnotation((JavaResourceAttribute)resourceAttribute, 0);
        annotation1.setValue("foo");
        XmlPathAnnotation annotation2 = this.getXmlPathAnnotation((JavaResourceAttribute)resourceAttribute, 1);
        annotation2.setValue("bar");
        this.assertSourceContains("@XmlPaths({ @XmlPath(\"foo\"), @XmlPath(\"bar\") })", cu);
        resourceAttribute.moveAnnotation(0, 1, "org.eclipse.persistence.oxm.annotations.XmlPath");
        this.assertSourceContains("@XmlPaths({ @XmlPath(\"bar\"), @XmlPath(\"foo\") })", cu);
        resourceAttribute.removeAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlPath");
        XmlPathAnnotationTests.assertEquals((int)1, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlPath"));
        this.assertSourceContains("@XmlPath(\"foo\")", cu);
        this.assertSourceDoesNotContain("@XmlPaths", cu);
    }
}

