/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.context.JaxbClass;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttachmentRefAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlIDREFAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlElementMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlElementMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlElement() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElement");
            }
        });
    }

    private ICompilationUnit createTypeWithCollectionXmlElement() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import java.util.List;").append(CR);
                sb.append("import javax.xml.bind.annotation.XmlElement;").append(CR);
                sb.append("import javax.xml.bind.annotation.XmlType;").append(CR);
                sb.append(CR);
                sb.append("@XmlType").append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" {").append(CR);
                sb.append("    @XmlElement").append(CR);
                sb.append("    public List<String> list;").append(CR);
                sb.append("}").append(CR);
            }
        };
        return this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createXmlTypeWithVariousAttributes() throws CoreException {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.xml.bind.annotation.XmlType").append(";").append(CR);
                sb.append("import java.util.List;").append(CR);
                sb.append(CR);
                sb.append("@XmlType").append(CR);
                sb.append("public class ").append("AnnotationTestType").append("{").append(CR);
                sb.append("    public String string;").append(CR);
                sb.append("    public List<String> stringList;").append(CR);
                sb.append("    public String[] stringArray;").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    public void testModifyName() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"id", (String)xmlElement.getQName().getDefaultName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"id", (String)xmlElement.getQName().getName());
        xmlElement.getQName().setSpecifiedName("foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getQName().getSpecifiedName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"id", (String)xmlElement.getQName().getDefaultName());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getQName().getName());
        xmlElement.getQName().setSpecifiedName(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedName());
    }

    public void testUpdateName() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedName());
    }

    public void testModifyNamespace() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedNamespace());
        xmlElement.getQName().setSpecifiedNamespace("foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementAnnotation.getNamespace());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getQName().getNamespace());
        xmlElement.getQName().setSpecifiedNamespace(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getNamespace());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getQName().getSpecifiedNamespace());
    }

    public void testModifyRequired() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isRequired());
        xmlElement.setSpecifiedRequired(Boolean.TRUE);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getRequired());
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElement.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElement.isRequired());
        xmlElement.setSpecifiedRequired(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isRequired());
    }

    public void testUpdateRequired() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isRequired());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "required", true);
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElement.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElement.isRequired());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultRequired());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isRequired());
    }

    public void testModifyNillable() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isNillable());
        xmlElement.setSpecifiedNillable(Boolean.TRUE);
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElementAnnotation.getNillable());
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElement.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElement.isNillable());
        xmlElement.setSpecifiedNillable(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getName());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isNillable());
    }

    public void testUpdateNillable() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isNillable());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "nillable", true);
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((Object)Boolean.TRUE, (Object)xmlElement.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElement.isNillable());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isNillable());
    }

    public void testDefaultNillable() throws Exception {
        this.createXmlTypeWithVariousAttributes();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = persistentAttribute.getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)1);
        xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        xmlElement = xmlElementMapping.getXmlElement();
        resourceAttribute = persistentAttribute.getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElement.isDefaultNillable());
        this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
        persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)2);
        xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        xmlElement = xmlElementMapping.getXmlElement();
        resourceAttribute = persistentAttribute.getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertEquals((boolean)true, (boolean)xmlElement.isDefaultNillable());
        this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute).edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElement");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((boolean)false, (boolean)xmlElement.isDefaultNillable());
    }

    public void testModifyDefaultValue() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getDefaultValue());
        xmlElement.setDefaultValue("foo");
        XmlElementAnnotation xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElementAnnotation.getDefaultValue());
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getDefaultValue());
        xmlElement.setDefaultValue(null);
        xmlElementAnnotation = (XmlElementAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementAnnotation.getDefaultValue());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getDefaultValue());
    }

    public void testUpdateDefaultValue() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getDefaultValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementMemberValuePair(declaration, "defaultValue", "foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"foo", (String)xmlElement.getDefaultValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getDefaultValue());
    }

    public void testModifyType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"int", (String)xmlElement.getType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"int", (String)xmlElement.getDefaultType());
        xmlElement.setSpecifiedType("Foo");
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElement.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElement.getType());
        xmlElement.setSpecifiedType(null);
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"int", (String)xmlElement.getType());
    }

    public void testUpdateType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        XmlElement xmlElement = xmlElementMapping.getXmlElement();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"int", (String)xmlElement.getDefaultType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"int", (String)xmlElement.getType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addXmlElementTypeMemberValuePair(declaration, "type", "Foo");
            }
        });
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElement.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"Foo", (String)xmlElement.getType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlElementAnnotation = (NormalAnnotation)GenericJavaXmlElementMappingTests.this.getXmlElementAnnotation(declaration);
                GenericJavaXmlElementMappingTests.this.values(xmlElementAnnotation).remove(0);
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElement.getSpecifiedType());
        GenericJavaXmlElementMappingTests.assertEquals((String)"int", (String)xmlElement.getType());
    }

    public void testChangeMappingType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        persistentAttribute.setMappingKey("xml-attribute");
        XmlAttributeMapping xmlAttributeMapping = (XmlAttributeMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlAttributeMapping);
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
        persistentAttribute.setMappingKey("xml-element");
        xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping);
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElement"));
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttribute"));
    }

    public void testModifyXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        xmlElementMapping.addXmlJavaTypeAdapter();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        xmlElementMapping.removeXmlJavaTypeAdapter();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testUpdateXmlJavaTypeAdapter() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlJavaTypeAdapter());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
    }

    public void testModifyXmlSchemaType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        xmlElementMapping.addXmlSchemaType();
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType"));
        xmlElementMapping.removeXmlSchemaType();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
    }

    public void testUpdateXmlSchemaType() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSchemaType");
            }
        });
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlSchemaType());
        GenericJavaXmlElementMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
    }

    protected void addXmlElementMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementAnnotation(declaration), name, value);
    }

    protected void addXmlElementMemberValuePair(ModifiedDeclaration declaration, String name, boolean value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementAnnotation(declaration), name, value);
    }

    protected void addXmlElementTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlElementAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlElementAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlElement");
    }

    public void testModifyXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        xmlElementMapping.addXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        xmlElementMapping.removeXmlElementWrapper();
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    public void testUpdateXmlElementWrapper() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlElementWrapperAnnotation xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementWrapperAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlElementWrapper");
            }
        });
        xmlElementWrapperAnnotation = (XmlElementWrapperAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlElementWrapper());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementWrapperAnnotation);
    }

    public void testModifyXmlList1() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlElementMapping.setSpecifiedXmlList(true);
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlElementMapping.setSpecifiedXmlList(false);
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testModifyXmlList2() throws Exception {
        this.createTypeWithCollectionXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlElementMapping.setSpecifiedXmlList(true);
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        xmlElementMapping.setSpecifiedXmlList(false);
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testUpdateXmlList1() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testUpdateXmlList2() throws Exception {
        this.createTypeWithCollectionXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertTrue((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlList");
            }
        });
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isDefaultXmlList());
        GenericJavaXmlElementMappingTests.assertFalse((boolean)xmlElementMapping.isSpecifiedXmlList());
        GenericJavaXmlElementMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlList"));
    }

    public void testModifyXmlID() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDAnnotation);
        xmlElementMapping.addXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDAnnotation);
        xmlElementMapping.removeXmlID();
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
    }

    public void testUpdateXmlID() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDAnnotation xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlID");
            }
        });
        xmlIDAnnotation = (XmlIDAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlID");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlID());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDAnnotation);
    }

    public void testModifyXmlIDREF() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
        xmlElementMapping.addXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        xmlElementMapping.removeXmlIDREF();
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }

    public void testUpdateXmlIDREF() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlIDREFAnnotation xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlIDREFAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlIDREF");
            }
        });
        xmlIDREFAnnotation = (XmlIDREFAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlIDREF");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlIDREF());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlIDREFAnnotation);
    }

    public void testModifyXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        xmlElementMapping.addXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        xmlElementMapping.removeXmlAttachmentRef();
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
    }

    public void testUpdateXmlAttachmentRef() throws Exception {
        this.createTypeWithXmlElement();
        JaxbClass jaxbClass = (JaxbClass)CollectionTools.get((Iterable)this.getContextRoot().getTypes(), (int)0);
        JaxbClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)CollectionTools.get((Iterable)classMapping.getAttributes(), (int)0);
        XmlElementMapping xmlElementMapping = (XmlElementMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = xmlElementMapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlAttachmentRefAnnotation xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNotNull((Object)xmlAttachmentRefAnnotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlElementMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttachmentRef");
            }
        });
        xmlAttachmentRefAnnotation = (XmlAttachmentRefAnnotation)resourceAttribute.getAnnotation("javax.xml.bind.annotation.XmlAttachmentRef");
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlElementMapping.getXmlAttachmentRef());
        GenericJavaXmlElementMappingTests.assertNull((Object)xmlAttachmentRefAnnotation);
    }
}

