/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.synchronizers.CallbackSynchronousSynchronizer;
import org.eclipse.jpt.common.utility.internal.synchronizers.SynchronousSynchronizer;
import org.eclipse.jpt.common.utility.synchronizers.CallbackSynchronizer;
import org.eclipse.jpt.common.utility.synchronizers.Synchronizer;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class TestJaxbProject
extends TestJavaProject {
    private final JaxbProject jaxbProject;
    public static final String JAXB_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jaxb.jar";
    public static final String ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public static String jaxbJarName() {
        return TestJaxbProject.getSystemProperty(JAXB_JAR_NAME_SYSTEM_PROPERTY);
    }

    public static String eclipselinkJarName() {
        return TestJaxbProject.getSystemProperty(ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY);
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public static TestJaxbProject buildJaxbProject(String baseProjectName, boolean autoBuild, IDataModel config) throws CoreException {
        return new TestJaxbProject(baseProjectName, autoBuild, config);
    }

    public TestJaxbProject(String projectName) throws CoreException {
        this(projectName, false);
    }

    public TestJaxbProject(String projectName, boolean autoBuild) throws CoreException {
        this(projectName, autoBuild, null);
    }

    public TestJaxbProject(String projectName, boolean autoBuild, IDataModel config) throws CoreException {
        super(projectName, autoBuild);
        String jaxbFacetVersion = ((IProjectFacetVersion)config.getProperty("IFacetDataModelPropeties.FACET_VERSION")).getVersionString();
        this.installFacet("jpt.jaxb", jaxbFacetVersion, config);
        this.addJar(TestJaxbProject.jaxbJarName());
        if (TestJaxbProject.eclipselinkJarName() != null) {
            this.addJar(TestJaxbProject.eclipselinkJarName());
        }
        this.jaxbProject = JptJaxbCorePlugin.getJaxbProject((IProject)this.getProject());
        this.jaxbProject.setContextModelSynchronizer(this.buildSynchronousContextModelSynchronizer());
        this.jaxbProject.setUpdateSynchronizer(this.buildSynchronousUpdateSynchronizer());
    }

    protected Synchronizer buildSynchronousContextModelSynchronizer() {
        return new SynchronousSynchronizer(this.buildSynchronousContextModelSynchronizerCommand());
    }

    protected Command buildSynchronousContextModelSynchronizerCommand() {
        return new SynchronousContextModelSynchronizerCommand();
    }

    protected CallbackSynchronizer buildSynchronousUpdateSynchronizer() {
        return new CallbackSynchronousSynchronizer(this.buildSynchronousUpdateSynchronizerCommand());
    }

    protected Command buildSynchronousUpdateSynchronizerCommand() {
        return new SynchronousUpdateSynchronizerCommand();
    }

    public JaxbProject getJaxbProject() {
        return this.jaxbProject;
    }

    protected class SynchronousContextModelSynchronizerCommand
    implements Command {
        protected SynchronousContextModelSynchronizerCommand() {
        }

        public void execute() {
            TestJaxbProject.this.jaxbProject.synchronizeContextModel((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected class SynchronousUpdateSynchronizerCommand
    implements Command {
        protected SynchronousUpdateSynchronizerCommand() {
        }

        public void execute() {
            TestJaxbProject.this.jaxbProject.update((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

