/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlJavaTypeAdapterPackageAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String TEST_CLASS = "TestClass";
    private static final String TEST_CLASS_2 = "TestClass2";
    private static final String FQ_TEST_CLASS = "test.TestClass";
    private static final String FQ_TEST_CLASS_2 = "test.TestClass2";

    public XmlJavaTypeAdapterPackageAnnotationTests(String name) {
        super(name);
    }

    private void createTestClass() throws CoreException {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(XmlJavaTypeAdapterPackageAnnotationTests.TEST_CLASS).append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestClass.java", sourceWriter);
    }

    private void createTestClass2() throws CoreException {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(XmlJavaTypeAdapterPackageAnnotationTests.TEST_CLASS_2).append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "TestClass2.java", sourceWriter);
    }

    private ICompilationUnit createPackageInfoWithJavaTypeAdapter() throws CoreException {
        return this.createTestPackageInfo("@XmlJavaTypeAdapter", new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
    }

    private ICompilationUnit createPackageInfoWithJavaTypeAdapterAndValue() throws CoreException {
        this.createTestClass();
        return this.createTestPackageInfo("@XmlJavaTypeAdapter(TestClass.class)", new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter", FQ_TEST_CLASS});
    }

    private ICompilationUnit createPackageInfoWithJavaTypeAdapterAndType() throws CoreException {
        this.createTestClass();
        return this.createTestPackageInfo("@XmlJavaTypeAdapter(type = TestClass.class)", new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter", FQ_TEST_CLASS});
    }

    private ICompilationUnit createPackageInfoWithJavaTypeAdapters() throws CoreException {
        return this.createTestPackageInfo("@XmlJavaTypeAdapters({@XmlJavaTypeAdapter,@XmlJavaTypeAdapter})", new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters", "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
    }

    public void testValue() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithJavaTypeAdapterAndValue();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        this.createTestClass2();
        XmlJavaTypeAdapterAnnotation annotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterPackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedValue());
        this.assertSourceContains("@XmlJavaTypeAdapter(TestClass.class)", cu);
        annotation.setValue(TEST_CLASS_2);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS_2, (String)annotation.getFullyQualifiedValue());
        this.assertSourceContains("@XmlJavaTypeAdapter(TestClass2.class)", cu);
        annotation.setValue(null);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals(null, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals(null, (String)annotation.getFullyQualifiedValue());
        this.assertSourceContains("@XmlJavaTypeAdapter", cu);
        annotation.setValue(TEST_CLASS);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedValue());
        this.assertSourceContains("@XmlJavaTypeAdapter(TestClass.class)", cu);
    }

    public void testType() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithJavaTypeAdapterAndType();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        this.createTestClass2();
        XmlJavaTypeAdapterAnnotation annotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterPackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapter(type = TestClass.class)", cu);
        annotation.setType(TEST_CLASS_2);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS_2, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapter(type = TestClass2.class)", cu);
        annotation.setType(null);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals(null, (String)annotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals(null, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapter", cu);
        annotation.setType(TEST_CLASS);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapter(type = TestClass.class)", cu);
    }

    public void testTypeWithValue() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithJavaTypeAdapterAndValue();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        this.createTestClass2();
        XmlJavaTypeAdapterAnnotation annotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterPackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getValue());
        this.assertSourceContains("@XmlJavaTypeAdapter(TestClass.class)", cu);
        annotation.setType(TEST_CLASS_2);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getType());
        this.assertSourceContains("@XmlJavaTypeAdapter(value = TestClass.class, type = TestClass2.class)", cu);
        annotation.setValue(null);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals(null, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getType());
        this.assertSourceContains("@XmlJavaTypeAdapter(type = TestClass2.class)", cu);
        annotation.setValue(TEST_CLASS);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getType());
        this.assertSourceContains("@XmlJavaTypeAdapter(type = TestClass2.class, value = TestClass.class)", cu);
        annotation.setType(null);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals(null, (String)annotation.getType());
        this.assertSourceContains("@XmlJavaTypeAdapter(TestClass.class)", cu);
    }

    public void testContainedWithValue() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithJavaTypeAdapters();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        this.createTestClass();
        XmlJavaTypeAdapterAnnotation adapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        adapterAnnotation.setValue(TEST_CLASS);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)adapterAnnotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)adapterAnnotation.getFullyQualifiedValue());
        this.assertSourceContains("@XmlJavaTypeAdapters({@XmlJavaTypeAdapter(TestClass.class),@XmlJavaTypeAdapter})", cu);
        adapterAnnotation.setValue(null);
        XmlJavaTypeAdapterPackageAnnotationTests.assertNull((Object)adapterAnnotation.getValue());
        XmlJavaTypeAdapterPackageAnnotationTests.assertNull((String)FQ_TEST_CLASS, (Object)adapterAnnotation.getFullyQualifiedValue());
        this.assertSourceContains("@XmlJavaTypeAdapters({@XmlJavaTypeAdapter,@XmlJavaTypeAdapter})", cu);
    }

    public void testContainedWithType() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithJavaTypeAdapters();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        this.createTestClass();
        XmlJavaTypeAdapterAnnotation adapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(1, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        adapterAnnotation.setType(TEST_CLASS);
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)adapterAnnotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)adapterAnnotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapters({@XmlJavaTypeAdapter,@XmlJavaTypeAdapter(type = TestClass.class)})", cu);
        resourcePackage.moveAnnotation(0, 1, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        adapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)adapterAnnotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)adapterAnnotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapters({@XmlJavaTypeAdapter(type = TestClass.class),@XmlJavaTypeAdapter})", cu);
        adapterAnnotation.setType(null);
        XmlJavaTypeAdapterPackageAnnotationTests.assertNull((Object)adapterAnnotation.getType());
        XmlJavaTypeAdapterPackageAnnotationTests.assertNull((String)FQ_TEST_CLASS, (Object)adapterAnnotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlJavaTypeAdapters({@XmlJavaTypeAdapter,@XmlJavaTypeAdapter})", cu);
    }

    public void testContained() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithJavaTypeAdapter();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        this.createTestClass();
        this.createTestClass2();
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((int)1, (int)resourcePackage.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        resourcePackage.addAnnotation(1, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((int)2, (int)resourcePackage.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        this.assertSourceContains("@XmlJavaTypeAdapters({ @XmlJavaTypeAdapter, @XmlJavaTypeAdapter })", cu);
        XmlJavaTypeAdapterAnnotation adapterAnnotation1 = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        adapterAnnotation1.setValue(TEST_CLASS);
        XmlJavaTypeAdapterAnnotation adapterAnnotation2 = (XmlJavaTypeAdapterAnnotation)resourcePackage.getAnnotation(1, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        adapterAnnotation2.setValue(TEST_CLASS_2);
        this.assertSourceContains("@XmlJavaTypeAdapters({ @XmlJavaTypeAdapter(TestClass.class), @XmlJavaTypeAdapter(TestClass2.class) })", cu);
        resourcePackage.moveAnnotation(0, 1, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        this.assertSourceContains("@XmlJavaTypeAdapters({ @XmlJavaTypeAdapter(TestClass2.class), @XmlJavaTypeAdapter(TestClass.class) })", cu);
        resourcePackage.removeAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterPackageAnnotationTests.assertEquals((int)1, (int)resourcePackage.getAnnotationsSize("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"));
        this.assertSourceContains("@XmlJavaTypeAdapter(TestClass.class)", cu);
        this.assertSourceDoesNotContain("@XmlJavaTypeAdapters", cu);
    }
}

