/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlJavaTypeAdapterTypeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_JAVA_TYPE_ADAPTER_CLASS = "MyAdapterClass";

    public XmlJavaTypeAdapterTypeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlJavaTypeAdapter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJavaTypeAdapter");
            }
        });
    }

    private ICompilationUnit createTestXmlJavaTypeAdapterWithValue() throws Exception {
        this.createTestAdapterClass();
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJavaTypeAdapter(value = MyAdapterClass.class)");
            }
        });
    }

    private void createTestAdapterClass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(XmlJavaTypeAdapterTypeAnnotationTests.XML_JAVA_TYPE_ADAPTER_CLASS).append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyAdapterClass.java", sourceWriter);
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlJavaTypeAdapter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterTypeAnnotationTests.assertTrue((xmlJavaTypeAdapterAnnotation != null ? 1 : 0) != 0);
        XmlJavaTypeAdapterTypeAnnotationTests.assertNull((Object)xmlJavaTypeAdapterAnnotation.getValue());
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlJavaTypeAdapterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterTypeAnnotationTests.assertTrue((xmlJavaTypeAdapterAnnotation != null ? 1 : 0) != 0);
        XmlJavaTypeAdapterTypeAnnotationTests.assertEquals((String)XML_JAVA_TYPE_ADAPTER_CLASS, (String)xmlJavaTypeAdapterAnnotation.getValue());
        XmlJavaTypeAdapterTypeAnnotationTests.assertEquals((String)"test.MyAdapterClass", (String)xmlJavaTypeAdapterAnnotation.getFullyQualifiedValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlJavaTypeAdapter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterTypeAnnotationTests.assertNull((Object)xmlJavaTypeAdapterAnnotation.getValue());
        xmlJavaTypeAdapterAnnotation.setValue(XML_JAVA_TYPE_ADAPTER_CLASS);
        XmlJavaTypeAdapterTypeAnnotationTests.assertEquals((String)XML_JAVA_TYPE_ADAPTER_CLASS, (String)xmlJavaTypeAdapterAnnotation.getValue());
        this.assertSourceContains("@XmlJavaTypeAdapter(MyAdapterClass.class)", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlJavaTypeAdapterWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlJavaTypeAdapterAnnotation xmlJavaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceType.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        XmlJavaTypeAdapterTypeAnnotationTests.assertEquals((String)XML_JAVA_TYPE_ADAPTER_CLASS, (String)xmlJavaTypeAdapterAnnotation.getValue());
        xmlJavaTypeAdapterAnnotation.setValue(null);
        XmlJavaTypeAdapterTypeAnnotationTests.assertNull((Object)xmlJavaTypeAdapterAnnotation.getValue());
        this.assertSourceContains("@XmlJavaTypeAdapter", cu);
        this.assertSourceDoesNotContain("@XmlJavaTypeAdapter(MyAdapterClass.class)", cu);
    }
}

