/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletTaskProvider;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDoxletAnnotationUtil;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.osgi.framework.Bundle;

public class XDocletEjbAntProjectBuilder
extends XDocletAntProjectBuilder {
    IProject clientProject;

    public XDocletEjbAntProjectBuilder() {
        this.templateUrl = Platform.getBundle((String)"org.eclipse.jst.j2ee.ejb.annotations.xdoclet").getEntry("/templates/builder/xdoclet.xml");
    }

    protected String getTaskName() {
        return "ejbdoclet";
    }

    protected HashMap createTemplates(String beanPath) {
        HashMap<String, String> templates = new HashMap<String, String>();
        templates.put("@beans@", beanPath);
        templates.put("@docletTasks@", this.createDocletTasks());
        return templates;
    }

    private String createDocletTasks() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.ejbDocletTaskProvider").getExtensions();
        StringBuffer tasks = new StringBuffer(512);
        int i = 0;
        while (extensions != null && i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null) {
                try {
                    String pluginDescriptor = elements[0].getDeclaringExtension().getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)pluginDescriptor);
                    Class c = bundle.loadClass(elements[0].getAttribute("class"));
                    if (c != null) {
                        XDocletTaskProvider docletTaskProvider = (XDocletTaskProvider)c.newInstance();
                        docletTaskProvider.setClientProject(this.clientProject);
                        docletTaskProvider.setPreferenceStore(this.preferenceStore);
                        docletTaskProvider.setExtension(extension);
                        docletTaskProvider.setProperties(this.getProperties());
                        docletTaskProvider.setProject(this.getProject());
                        if (this.preferenceStore.getBooleanProperty(String.valueOf(elements[0].getAttribute("id")) + ".defaultSelection")) {
                            tasks.append("\n");
                            tasks.append(docletTaskProvider.getTask());
                            tasks.append("\n");
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            ++i;
        }
        return tasks.toString();
    }

    public Properties createAntBuildProperties(IResource resource, IJavaProject javaProject, IPackageFragmentRoot packageFragmentRoot, String beanPath) {
        Properties properties = new Properties();
        StructureEdit core = null;
        EJBArtifactEdit ejbEdit = null;
        try {
            try {
                core = StructureEdit.getStructureEditForRead((IProject)javaProject.getProject());
                ArrayList ejbs = new ArrayList();
                this.getAllAnnotatedEjbs((IParent)packageFragmentRoot, ejbs);
                String projectDir = resource.getProject().getLocation().toString();
                String moduleDir = packageFragmentRoot.getResource().getLocation().toString();
                properties.put("ejb", resource.getProject().getName());
                properties.put("ejb.project.dir", projectDir);
                properties.put("ejb.project.classpath", this.asClassPath(javaProject));
                properties.put("ejb.module.src", moduleDir);
                properties.put("ejb.module.gen", packageFragmentRoot.getResource().getLocation().toString());
                properties.put("ejb.bin.dir", this.getJavaProjectOutputContainer(javaProject).toString());
                properties.put("xdoclet.home", this.getPreferenceStore().getProperty("XDOCLETHOME"));
                URL url = Platform.getBundle((String)"org.apache.ant").getEntry("/");
                url = FileLocator.toFileURL((URL)url);
                File file = new File(url.getFile());
                properties.put("ant.home", file.getAbsolutePath());
                WorkbenchComponent ejbModule = core.getComponent();
                IProject proj = javaProject.getProject();
                ejbEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)proj);
                int ejbLevelI = 20;
                try {
                    ejbLevelI = ejbEdit.getEJBJarXmiResource().getModuleVersionID();
                }
                catch (RuntimeException runtimeException) {}
                String ejbLevel = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)proj);
                if ((ejbLevel == null || ejbLevel.length() == 0) && ejbLevelI == 20) {
                    ejbLevel = "2.0";
                } else if ((ejbLevel == null || ejbLevel.length() == 0) && ejbLevelI == 21) {
                    ejbLevel = "2.1";
                }
                this.setEjbClientJarProperties(properties, core, ejbModule);
                IPath metaInfPath = this.getMetaInfFolder(ejbModule);
                String metaInf = String.valueOf(moduleDir) + "/META-INF";
                if (metaInfPath != null) {
                    metaInf = String.valueOf(projectDir) + "/" + metaInfPath.toString();
                }
                properties.put("ejb.spec.version", ejbLevel);
                properties.put("ejb.metainf.dir", metaInf);
                properties.put("xdoclet.merge.dir", metaInf);
                properties.put("java.class.path", "");
                properties.put("project.class.path", "");
                properties.put("project.path", "");
                properties.put("ejb.dd.displayname", ejbModule.getName());
                properties.put("ejb.dd.description", String.valueOf(ejbModule.getName()) + " generated by eclipse wtp xdoclet extension.");
            }
            catch (Exception e) {
                Logger.logException(e);
                if (core != null) {
                    core.dispose();
                }
                if (ejbEdit != null) {
                    ejbEdit.dispose();
                }
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
            if (ejbEdit != null) {
                ejbEdit.dispose();
            }
        }
        return properties;
    }

    private void setEjbClientJarProperties(Properties properties, StructureEdit core, WorkbenchComponent ejbModule) throws UnresolveableURIException {
        this.clientProject = null;
        IVirtualReference[] refs = null;
        IProject ejbProject = ProjectUtilities.getProject((EObject)ejbModule);
        IVirtualComponent ejbComp = ComponentCore.createComponent((IProject)ejbProject);
        if (ejbComp != null) {
            refs = ejbComp.getReferences();
        }
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                IVirtualReference refComp = refs[i];
                IVirtualComponent referencedComp = refComp.getReferencedComponent();
                IProject project = referencedComp.getProject();
                if (J2EEProjectUtilities.isUtilityProject((IProject)project)) {
                    properties.put("ejb.dd.clientjar", refComp.getArchiveName());
                    this.setClientJarSourcepath(properties, ejbModule, refComp);
                }
                ++i;
            }
        }
    }

    private void setClientJarSourcepath(Properties properties, WorkbenchComponent ejbModule, IVirtualReference refComp) {
        IVirtualComponent referencedComp = refComp.getReferencedComponent();
        this.clientProject = referencedComp.getProject();
        IContainer[] clientJarResources = referencedComp.getRootFolder().getUnderlyingFolders();
        List sourcePaths = JemProjectUtilities.getSourceContainers((IProject)this.clientProject);
        int i = 0;
        while (i < clientJarResources.length) {
            IContainer folder = clientJarResources[i];
            IPath sPath = folder.getProjectRelativePath();
            for (IFolder pSPath : sourcePaths) {
                if (!sPath.makeRelative().equals((Object)pSPath.getProjectRelativePath())) continue;
                properties.put("ejb.client.module.src", pSPath.getLocation().toString());
                return;
            }
            ++i;
        }
    }

    protected String constructAnnotatedClassList(IPackageFragmentRoot root, IResource changedBean) {
        ArrayList ejbs = new ArrayList();
        this.getAllAnnotatedEjbs((IParent)root, ejbs);
        String beans = "";
        try {
            for (ICompilationUnit cu : ejbs) {
                IResource bean = cu.getCorrespondingResource();
                IPath path = bean.getProjectRelativePath();
                path = this.makeRelativeTo(path, root);
                beans = String.valueOf(beans) + "\t<include name=\"" + path.toString() + "\" />\n";
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        return beans;
    }

    private void getAllAnnotatedEjbs(IParent root, List list) {
        IJavaElement[] elements = null;
        try {
            if (root == null) {
                return;
            }
            elements = root.getChildren();
            if (elements == null) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                IJavaElement element = elements[i];
                if (XDoxletAnnotationUtil.isXDocletAnnotatedEjbClass(element)) {
                    list.add(element);
                } else if (element.getElementType() == 4) {
                    this.getAllAnnotatedEjbs((IParent)((IPackageFragment)element), list);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
    }

    protected void refreshProjects(IProject project, IProgressMonitor monitor) throws CoreException {
        project.refreshLocal(2, monitor);
        if (this.clientProject != null) {
            this.clientProject.refreshLocal(2, monitor);
        }
    }

    protected IPath getMetaInfFolder(WorkbenchComponent ejbModule) {
        ComponentResource[] METAINF = ejbModule.findResourcesByRuntimePath((IPath)new Path("/META-INF"));
        int i = 0;
        while (i < METAINF.length) {
            ComponentResource resource = METAINF[i];
            if (resource.getRuntimePath().toString().equals("/META-INF")) {
                return resource.getSourcePath();
            }
            ++i;
        }
        if (METAINF.length > 0) {
            return METAINF[0].getSourcePath();
        }
        return null;
    }
}

